/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.api.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.data.inner.AttackListData;
import com.github.tartaricacid.touhoulittlemaid.entity.item.AbstractEntityFromItem;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.DefaultMonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.misc.MonsterType;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.AttackTaskConfigContainer;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public interface IAttackTask
extends IMaidTask {
    public static final String MAID_NO_ATTACK_TAG = "MaidNoAttack";

    public static Optional<? extends LivingEntity> findFirstValidAttackTarget(EntityMaid maid) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_148205_).flatMap(mobs -> mobs.m_186116_(e -> maid.m_6779_((LivingEntity)e) && maid.m_21444_(e.m_20183_())));
    }

    default public boolean canAttack(EntityMaid maid, LivingEntity target) {
        TamableAnimal tamableAnimal;
        ResourceLocation location = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        if (location == null) {
            return false;
        }
        String id = location.toString();
        if (target instanceof ArmorStand || target instanceof AbstractEntityFromItem || target instanceof Player) {
            return false;
        }
        if (target instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)target).m_21805_() != null) {
            return false;
        }
        if (target.m_7770_() != null && target.m_7770_().getString().startsWith(MAID_NO_ATTACK_TAG)) {
            return false;
        }
        if (((List)MaidConfig.MAID_ATTACK_IGNORE.get()).contains(id)) {
            return false;
        }
        AttackListData attackListData = maid.getData(InitTaskData.ATTACK_LIST);
        MonsterType monsterType = attackListData != null && attackListData.attackGroups().containsKey(location) ? attackListData.attackGroups().get(location) : DefaultMonsterType.getMonsterType(target);
        return DefaultMonsterType.canAttack(maid, target, monsterType);
    }

    default public boolean hasExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }

    default public boolean doExtraAttack(EntityMaid maid, Entity target) {
        return false;
    }

    default public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        return false;
    }

    @Override
    default public MenuProvider getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.m_19879_();
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237113_((String)"Maid Attack Config Container");
            }

            public AbstractMaidContainer createMenu(int index, Inventory playerInventory, Player player) {
                return new AttackTaskConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    default public boolean enablePanic(EntityMaid maid) {
        return false;
    }
}

