/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.config;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.service.stt.STTApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.SupportLanguage;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.AbstractMaidContainerGui;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.HistoryAIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.SettingEditScreen;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.MaidAIChatConfigButton;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.config.MaidAIChatConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.SaveMaidAIDataMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.anti_ad.mc.ipn.api.IPNButton;
import org.anti_ad.mc.ipn.api.IPNGuiHint;
import org.anti_ad.mc.ipn.api.IPNGuiHints;
import org.anti_ad.mc.ipn.api.IPNPlayerSideOnly;
import org.apache.commons.lang3.StringUtils;

@IPNPlayerSideOnly
@IPNGuiHints(value={@IPNGuiHint(button=IPNButton.SORT, horizontalOffset=-36, bottom=-12), @IPNGuiHint(button=IPNButton.SORT_COLUMNS, horizontalOffset=-24, bottom=-24), @IPNGuiHint(button=IPNButton.SORT_ROWS, horizontalOffset=-12, bottom=-36), @IPNGuiHint(button=IPNButton.SHOW_EDITOR, horizontalOffset=-5), @IPNGuiHint(button=IPNButton.SETTINGS, horizontalOffset=-5)})
public class MaidAIChatConfigContainerGui
extends AbstractMaidContainerGui<MaidAIChatConfigContainer> {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_ai_chat_config.png");
    private final MaidAIChatManager manager;
    private final Map<String, Map<String, String>> llmSites;
    private final Map<String, Map<String, String>> ttsSites;
    private final List<String> sttSites = Lists.newArrayList(AvailableSites.STT_SITES.keySet());

    public MaidAIChatConfigContainerGui(MaidAIChatConfigContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.maid.getAiChatManager().readFromTag(screenContainer.getConfigData());
        this.manager = this.maid.getAiChatManager();
        this.llmSites = screenContainer.getLLMSites();
        this.ttsSites = screenContainer.getTTSSites();
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        graphics.m_280218_(ICON, this.f_97735_ + 80, this.f_97736_ + 28, 0, 0, 176, 137);
    }

    @Override
    protected void initAdditionWidgets() {
        int buttonLeft = this.f_97735_ + 86;
        int buttonTop = this.f_97736_ + 38;
        this.addConfigButtons(buttonLeft, buttonTop);
        this.addOtherButtons(buttonLeft);
    }

    private void addOtherButtons(int buttonLeft) {
        MutableComponent edit = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.edit_custom_setting.edit");
        MutableComponent history = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.open_history_chat");
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)edit, button -> {
            this.m_7856_();
            this.saveConfig();
            this.getMinecraft().m_91152_((Screen)new SettingEditScreen(this.maid));
        }).m_252987_(buttonLeft + 2, this.f_97736_ + 120, 160, 18).m_257505_(Tooltip.m_257550_((Component)edit)).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)history, button -> {
            this.saveConfig();
            this.getMinecraft().m_91152_((Screen)new HistoryAIChatScreen(this.maid));
        }).m_252987_(buttonLeft + 2, this.f_97736_ + 140, 160, 18).m_257505_(Tooltip.m_257550_((Component)history)).m_253136_());
    }

    private void addConfigButtons(int buttonLeft, int buttonTop) {
        MutableComponent noSiteSelectedName = Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.no_site_selected");
        MutableComponent llmSiteName = Component.m_237113_((String)this.manager.llmSite);
        MutableComponent ttsSiteName = Component.m_237113_((String)this.manager.ttsSite);
        this.m_142416_((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.llm_site"), (Component)(this.manager.llmSite.isBlank() ? noSiteSelectedName : llmSiteName), button -> {
            this.manager.llmSite = this.onClickSites(this.llmSites, this.manager.llmSite, button, true);
            this.m_7856_();
            this.saveConfig();
        }, button -> {
            this.manager.llmSite = this.onClickSites(this.llmSites, this.manager.llmSite, button, false);
            this.m_7856_();
            this.saveConfig();
        }));
        buttonTop += 13;
        Map<String, String> llmModels = this.llmSites.get(this.manager.llmSite);
        if (llmModels != null && !llmModels.isEmpty()) {
            String name = llmModels.get(this.manager.llmModel);
            if (StringUtils.isBlank((CharSequence)name)) {
                this.manager.llmModel = llmModels.keySet().iterator().next();
                name = llmModels.get(this.manager.llmModel);
            }
            this.m_142416_((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.llm_model"), (Component)Component.m_237113_((String)name), button -> {
                this.manager.llmModel = this.onClickModels(llmModels, this.manager.llmModel, button, true);
                this.saveConfig();
            }, button -> {
                this.manager.llmModel = this.onClickModels(llmModels, this.manager.llmModel, button, false);
                this.saveConfig();
            }));
            buttonTop += 13;
        }
        this.m_142416_((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_site"), (Component)(this.manager.ttsSite.isBlank() ? noSiteSelectedName : ttsSiteName), button -> {
            this.manager.ttsSite = this.onClickSites(this.ttsSites, this.manager.ttsSite, button, true);
            this.m_7856_();
            this.saveConfig();
        }, button -> {
            this.manager.ttsSite = this.onClickSites(this.ttsSites, this.manager.ttsSite, button, false);
            this.m_7856_();
            this.saveConfig();
        }));
        buttonTop += 13;
        Map<String, String> ttsModels = this.ttsSites.get(this.manager.ttsSite);
        if (ttsModels != null && !ttsModels.isEmpty()) {
            String name = ttsModels.get(this.manager.ttsModel);
            if (StringUtils.isBlank((CharSequence)name)) {
                this.manager.ttsModel = ttsModels.keySet().iterator().next();
                name = ttsModels.get(this.manager.ttsModel);
            }
            this.m_142416_((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_model"), (Component)Component.m_237113_((String)name), button -> {
                this.manager.ttsModel = this.onClickModels(ttsModels, this.manager.ttsModel, button, true);
                this.saveConfig();
            }, button -> {
                this.manager.ttsModel = this.onClickModels(ttsModels, this.manager.ttsModel, button, false);
                this.saveConfig();
            }));
            buttonTop += 13;
        }
        if (StringUtils.isBlank((CharSequence)this.manager.ttsLanguage)) {
            this.manager.ttsLanguage = SupportLanguage.SUPPORTED_LANGUAGES.get(0);
        }
        this.m_142416_((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.tts_language"), SupportLanguage.getLanguageName(this.manager.ttsLanguage), button -> {
            this.manager.ttsLanguage = SupportLanguage.findPrev(this.manager.ttsLanguage);
            button.setValue(SupportLanguage.getLanguageName(this.manager.ttsLanguage));
            this.saveConfig();
        }, button -> {
            this.manager.ttsLanguage = SupportLanguage.findNext(this.manager.ttsLanguage);
            button.setValue(SupportLanguage.getLanguageName(this.manager.ttsLanguage));
            this.saveConfig();
        }));
        this.addSttButtons(buttonLeft, buttonTop += 13);
    }

    private void addSttButtons(int buttonLeft, int buttonTop) {
        String sttType = ((STTApiType)((Object)AIConfig.STT_TYPE.get())).getName();
        if (this.sttSites.isEmpty()) {
            sttType = "";
        } else if (!this.sttSites.contains(sttType)) {
            sttType = this.sttSites.get(0);
        }
        String finalSttType = sttType;
        this.m_142416_((GuiEventListener)new MaidAIChatConfigButton(buttonLeft, buttonTop, (Component)Component.m_237115_((String)"config.touhou_little_maid.global_ai.stt_type"), (Component)Component.m_237113_((String)sttType), button -> {
            if (this.sttSites.isEmpty()) {
                return;
            }
            int index = this.sttSites.indexOf(finalSttType);
            if (index != -1) {
                if (--index < 0) {
                    index = this.sttSites.size() - 1;
                }
                AIConfig.STT_TYPE.set((Object)STTApiType.getByName(this.sttSites.get(index)));
            } else {
                AIConfig.STT_TYPE.set((Object)STTApiType.PLAYER2);
            }
            button.setValue((Component)Component.m_237113_((String)((STTApiType)((Object)((Object)AIConfig.STT_TYPE.get()))).getName()));
            this.m_7856_();
        }, button -> {
            if (this.sttSites.isEmpty()) {
                return;
            }
            int index = this.sttSites.indexOf(finalSttType);
            if (index != -1) {
                if (++index >= this.sttSites.size()) {
                    index = 0;
                }
                AIConfig.STT_TYPE.set((Object)STTApiType.getByName(this.sttSites.get(index)));
            } else {
                AIConfig.STT_TYPE.set((Object)STTApiType.PLAYER2);
            }
            button.setValue((Component)Component.m_237113_((String)((STTApiType)((Object)((Object)AIConfig.STT_TYPE.get()))).getName()));
            this.m_7856_();
        }));
    }

    private String onClickSites(Map<String, Map<String, String>> sites, String site, MaidAIChatConfigButton button, boolean isLeft) {
        if (sites.isEmpty()) {
            button.setValue((Component)Component.m_237119_());
            return "";
        }
        ArrayList keys = Lists.newArrayList(sites.keySet());
        if (keys.size() == 1) {
            button.setValue((Component)Component.m_237113_((String)((String)keys.get(0))));
            return (String)keys.get(0);
        }
        int index = keys.indexOf(site);
        if (index < 0) {
            button.setValue((Component)Component.m_237113_((String)((String)keys.get(0))));
            return (String)keys.get(0);
        }
        if (isLeft) {
            if (--index < 0) {
                index = keys.size() - 1;
            }
        } else if (++index >= keys.size()) {
            index = 0;
        }
        String id = (String)keys.get(index);
        button.setValue((Component)Component.m_237113_((String)id));
        return id;
    }

    private String onClickModels(Map<String, String> models, String model, MaidAIChatConfigButton button, boolean isLeft) {
        if (models.isEmpty()) {
            button.setValue((Component)Component.m_237115_((String)"gui.touhou_little_maid.button.maid_ai_chat_config.default_model"));
            return "";
        }
        ArrayList keys = Lists.newArrayList(models.keySet());
        if (keys.size() == 1) {
            String id = (String)keys.get(0);
            button.setValue((Component)Component.m_237113_((String)models.get(id)));
            return id;
        }
        int index = keys.indexOf(model);
        if (index < 0) {
            String id = (String)keys.get(0);
            button.setValue((Component)Component.m_237113_((String)models.get(id)));
            return id;
        }
        if (isLeft) {
            if (--index < 0) {
                index = keys.size() - 1;
            }
        } else if (++index >= keys.size()) {
            index = 0;
        }
        String id = (String)keys.get(index);
        button.setValue((Component)Component.m_237113_((String)models.get(id)));
        return id;
    }

    private void saveConfig() {
        NetworkHandler.CHANNEL.sendToServer((Object)new SaveMaidAIDataMessage(this.maid.m_19879_(), this.manager));
    }
}

