/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MaidAIChatConfigButton
extends Button {
    private static final ResourceLocation ICON = new ResourceLocation("touhou_little_maid", "textures/gui/maid_ai_chat_config.png");
    private final OnPress leftPress;
    private final OnPress rightPress;
    private boolean leftClicked = false;
    private Component value;

    public MaidAIChatConfigButton(int x, int y, Component title, Component value, OnPress onLeftPressIn, OnPress onRightPressIn) {
        super(Button.m_253074_((Component)title, b -> {}).m_252794_(x, y).m_253046_(164, 13));
        this.leftPress = onLeftPressIn;
        this.rightPress = onRightPressIn;
        this.value = value;
    }

    public MaidAIChatConfigButton(int x, int y, Component title, Component value, OnPress onPress) {
        this(x, y, title, value, onPress, onPress);
    }

    protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.enableDepthTest();
        if (this.f_93622_) {
            graphics.m_280163_(ICON, this.m_252754_(), this.m_252907_(), 6.0f, 150.0f, this.f_93618_, this.f_93619_, 256, 256);
        } else {
            graphics.m_280163_(ICON, this.m_252754_(), this.m_252907_(), 6.0f, 137.0f, this.f_93618_, this.f_93619_, 256, 256);
        }
        this.drawButtonText(graphics, mc.f_91062_);
    }

    public void setValue(Component value) {
        this.value = value;
    }

    protected boolean m_93680_(double mouseX, double mouseY) {
        boolean clickY;
        if (!this.f_93623_ || !this.f_93624_) {
            return false;
        }
        boolean leftClickX = (double)(this.m_252754_() + 62) <= mouseX && mouseX <= (double)(this.m_252754_() + 72);
        boolean rightClickX = (double)(this.m_252754_() + 154) <= mouseX && mouseX <= (double)(this.m_252754_() + 164);
        boolean bl = clickY = (double)this.m_252907_() <= mouseY && mouseY <= (double)(this.m_252907_() + this.m_93694_());
        if (leftClickX && clickY) {
            this.leftClicked = true;
            return true;
        }
        if (rightClickX && clickY) {
            this.leftClicked = false;
            return true;
        }
        return false;
    }

    public void m_5691_() {
        if (this.leftClicked) {
            this.leftPress.onPress(this);
        } else {
            this.rightPress.onPress(this);
        }
    }

    public void drawButtonText(GuiGraphics graphics, Font font) {
        float scale = 0.75f;
        FormattedCharSequence leftText = this.m_6035_().m_7532_();
        FormattedCharSequence rightText = this.value.m_7532_();
        float leftTextX = (float)(this.m_252754_() + 5) / scale;
        float leftTextY = (float)(this.m_252907_() + 4) / scale;
        float rightTextX = ((float)(this.m_252754_() + 113) - (float)font.m_92724_(rightText) * scale / 2.0f) / scale;
        float rightTextY = (float)(this.m_252907_() + 4) / scale;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 1.0f);
        graphics.drawString(font, leftText, leftTextX, leftTextY, 0x444444, false);
        graphics.drawString(font, rightText, rightTextX, rightTextY, 0x55FF55, false);
        graphics.m_280168_().m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnPress {
        public void onPress(MaidAIChatConfigButton var1);
    }
}

