/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.common;

import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.task.TaskGunAttack;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.tacz.TacCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GunCommonUtil {
    public static void initAndAddTask(TaskManager manager) {
        boolean tacz = TacCompat.init();
        boolean sbw = SWarfareCompat.init();
        if (tacz || sbw) {
            manager.add(new TaskGunAttack());
        }
    }

    public static boolean isInstalled() {
        return TacCompat.isInstalled() || SWarfareCompat.isInstalled();
    }

    public static boolean isGun(ItemStack stack) {
        return SWarfareCompat.isGun(stack) || TacCompat.isGun(stack);
    }

    public static boolean canStartAttacking(EntityMaid maid) {
        Player player;
        Entity playerVehicle;
        ItemStack item = maid.m_21205_();
        if (GunCommonUtil.isGun(item)) {
            return true;
        }
        Entity vehicle = maid.m_20202_();
        if (vehicle != null) {
            return SWarfareCompat.isVehicle(vehicle);
        }
        LivingEntity owner = maid.m_269323_();
        if (owner instanceof Player && (playerVehicle = (player = (Player)owner).m_20202_()) != null && playerVehicle.m_20197_().contains(maid)) {
            return SWarfareCompat.isVehicle(playerVehicle);
        }
        return false;
    }

    @Nullable
    public static ResourceLocation getGunId(ItemStack stack) {
        if (SWarfareCompat.isGun(stack)) {
            return SWarfareCompat.getGunId(stack);
        }
        if (TacCompat.isGun(stack)) {
            return TacCompat.getGunId(stack);
        }
        return null;
    }

    public static Optional<Boolean> canSee(EntityMaid maid, LivingEntity target) {
        ItemStack handItem = maid.m_21205_();
        if (TacCompat.isGun(handItem)) {
            return Optional.of(TacCompat.canSee(maid, target));
        }
        if (SWarfareCompat.isGun(handItem)) {
            return Optional.of(SWarfareCompat.canSee(maid, target));
        }
        return SWarfareCompat.canVehicleSee(maid, target);
    }

    public static void tick(EntityMaid shooter, LivingEntity target, ItemStack gunItem) {
        if (SWarfareCompat.isGun(gunItem)) {
            SWarfareCompat.tick(shooter, target, gunItem);
        }
    }

    public static int performGunAttack(EntityMaid shooter, LivingEntity target, ItemStack gunItem) throws Exception {
        if (TacCompat.isGun(gunItem)) {
            return TacCompat.performGunAttack(shooter, target, gunItem);
        }
        if (SWarfareCompat.isGun(gunItem)) {
            return SWarfareCompat.performGunAttack(shooter, target, gunItem);
        }
        return 100;
    }

    public static void onStop(EntityMaid maid, GunShootTargetTask task) {
        TacCompat.stopAim(maid);
        SWarfareCompat.onStop(maid, task);
    }
}

