/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.kubejs.register.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class TaskBuilder<T extends TaskBuilder<T, E>, E> {
    @HideFromJS
    public final ResourceLocation id;
    @HideFromJS
    public final ItemStack icon;
    @HideFromJS
    public final List<Pair<Integer, BiFunction<E, EntityMaid, BehaviorControl<? super EntityMaid>>>> brains = Lists.newArrayList();
    @HideFromJS
    public final List<Pair<Integer, BiFunction<E, EntityMaid, BehaviorControl<? super EntityMaid>>>> rideBrains = Lists.newArrayList();
    @HideFromJS
    public final List<Pair<String, Predicate<EntityMaid>>> enableConditionDesc = Lists.newArrayList();
    @HideFromJS
    public final List<Pair<String, Predicate<EntityMaid>>> conditionDesc = Lists.newArrayList();
    @HideFromJS
    @Nullable
    public Predicate<EntityMaid> enable = null;
    @HideFromJS
    @Nullable
    public Predicate<EntityMaid> enableLookAndRandomWalk = null;
    @HideFromJS
    @Nullable
    public Predicate<EntityMaid> enableEating = null;
    @HideFromJS
    @Nullable
    public SoundEvent sound;

    public TaskBuilder(ResourceLocation id, ItemStack icon) {
        this.id = id;
        this.icon = icon;
    }

    @Info(value="Adds a brain to the task. Generally, no content needs to be added here unless you need to add some special behavior control. <br>\n\u5411\u4efb\u52a1\u6dfb\u52a0\u4e00\u4e2a\u65b0\u7684 Brain\u3002\u4e00\u822c\u6765\u8bf4\u8fd9\u91cc\u4e0d\u9700\u8981\u6dfb\u52a0\u4efb\u4f55\u5185\u5bb9\uff0c\u9664\u975e\u4f60\u9700\u8981\u6dfb\u52a0\u4e00\u4e9b\u7279\u6b8a\u7684\u884c\u4e3a\u63a7\u5236\u3002\n", params={@Param(name="priority", value="The priority of the brain task, higher values are executed first. <br>\nBrain \u7684\u4f18\u5148\u7ea7\uff0c\u503c\u8d8a\u5c0f\u8d8a\u5148\u6267\u884c\uff0c\u4e00\u822c\u4e3a 5\u3002\n"), @Param(name="control", value="The behavior control object. <br>\nBrain \u5bf9\u8c61\u3002\n")})
    public T addBrain(int priority, BiFunction<E, EntityMaid, BehaviorControl<? super EntityMaid>> control) {
        this.brains.add(Pair.of((Object)priority, control));
        return (T)this;
    }

    @Info(value="Adds a ride brain to the task. Generally, no content needs to be added here unless you need to add some special behavior control. <br>\n\u5411\u4efb\u52a1\u6dfb\u52a0\u4e00\u4e2a\u65b0\u7684\u9a91\u4e58\u72b6\u6001\u4e0b\u7684 Brain\u3002\u4e00\u822c\u6765\u8bf4\u8fd9\u91cc\u4e0d\u9700\u8981\u6dfb\u52a0\u4efb\u4f55\u5185\u5bb9\uff0c\u9664\u975e\u4f60\u9700\u8981\u6dfb\u52a0\u4e00\u4e9b\u7279\u6b8a\u7684\u884c\u4e3a\u63a7\u5236\u3002\n", params={@Param(name="priority", value="The priority of the ride brain task, higher values are executed first. <br>\n\u9a91\u4e58\u72b6\u6001\u4e0b\u7684 Brain \u7684\u4f18\u5148\u7ea7\uff0c\u503c\u8d8a\u5c0f\u8d8a\u5148\u6267\u884c\uff0c\u4e00\u822c\u4e3a 5\u3002\n"), @Param(name="control", value="The behavior control object. <br>\n\u9a91\u4e58\u72b6\u6001\u4e0b\u7684 Brain \u5bf9\u8c61\u3002\n")})
    public T addRideBrain(int priority, BiFunction<E, EntityMaid, BehaviorControl<? super EntityMaid>> control) {
        this.rideBrains.add(Pair.of((Object)priority, control));
        return (T)this;
    }

    @Info(value="Adds a description for the enable condition of the task. <br>\n\u5411\u4efb\u52a1\u6dfb\u52a0\u4e00\u4e2a\u542f\u7528\u6761\u4ef6\u7684\u63cf\u8ff0\u3002\n", params={@Param(name="languageKey", value="The language key for the description. <br>\n\u63cf\u8ff0\u7684\u8bed\u8a00\u6587\u4ef6 key\u3002\n"), @Param(name="condition", value="The condition that must be met for the task to be enabled. <br>\n\u4efb\u52a1\u542f\u7528\u6240\u9700\u6ee1\u8db3\u7684\u6761\u4ef6\u3002\n")})
    public T addEnableConditionDesc(String languageKey, Predicate<EntityMaid> condition) {
        this.enableConditionDesc.add((Pair<String, Predicate<EntityMaid>>)Pair.of((Object)languageKey, condition));
        return (T)this;
    }

    @Info(value="Adds a description for the condition of the task. <br>\n\u5411\u4efb\u52a1\u6dfb\u52a0\u4e00\u4e2a\u666e\u901a\u63cf\u8ff0\u3002\n", params={@Param(name="languageKey", value="The language key for the description. <br>\n\u63cf\u8ff0\u7684\u8bed\u8a00\u6587\u4ef6 key\u3002\n"), @Param(name="condition", value="The condition that must be met for the task to be considered valid. <br>\n\u4efb\u52a1\u88ab\u8ba4\u4e3a\u6709\u6548\u6240\u9700\u6ee1\u8db3\u7684\u6761\u4ef6\u3002\n")})
    public T addConditionDesc(String languageKey, Predicate<EntityMaid> condition) {
        this.conditionDesc.add((Pair<String, Predicate<EntityMaid>>)Pair.of((Object)languageKey, condition));
        return (T)this;
    }

    @Info(value="Sets the enable condition for the task. <br>\n\u8bbe\u7f6e\u4efb\u52a1\u7684\u542f\u7528\u6761\u4ef6\u3002\n")
    public T enable(Predicate<EntityMaid> enable) {
        this.enable = enable;
        return (T)this;
    }

    @Info(value="Sets the condition for enabling look and random walk behavior in the task. <br>\n\u8bbe\u7f6e\u4efb\u52a1\u4e2d\u662f\u5426\u542f\u7528\u56db\u5904\u5f20\u671b\u548c\u968f\u673a\u884c\u8d70 AI\u3002\n")
    public T enableLookAndRandomWalk(Predicate<EntityMaid> enableLookAndRandomWalk) {
        this.enableLookAndRandomWalk = enableLookAndRandomWalk;
        return (T)this;
    }

    @Info(value="Sets the condition for enabling eating behavior in the task. <br>\n\u8bbe\u7f6e\u4efb\u52a1\u4e2d\u662f\u5426\u542f\u7528\u5403\u4e1c\u897f AI\u3002\n")
    public T enableEating(Predicate<EntityMaid> enableEating) {
        this.enableEating = enableEating;
        return (T)this;
    }

    @Info(value="Set the sound for the task. Generally, it does not need to be modified unless you want to customize the sound. <br>\n\u8bbe\u7f6e\u8be5\u4efb\u52a1\u6240\u64ad\u653e\u7684\u97f3\u6548\uff0c\u4e00\u822c\u4e0d\u9700\u8981\u4fee\u6539\uff0c\u9664\u975e\u4f60\u9700\u8981\u81ea\u5b9a\u4e49\u97f3\u6548\u3002\n")
    public T sound(SoundEvent sound) {
        this.sound = sound;
        return (T)this;
    }
}

