/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class MaidFollowOwnerTask
extends Behavior<EntityMaid> {
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, EntityMaid maid) {
        LivingEntity owner = maid.m_269323_();
        if (this.ownerStateConditions(owner, maid)) {
            if (maid.getSwimManager().isGoingToBreath()) {
                return !owner.m_5842_();
            }
            return true;
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        LivingEntity owner = maid.m_269323_();
        if (maid.getSwimManager().isGoingToBreath() && this.ownerStateConditions(owner, maid) && this.maidStateConditions(maid) && maid.teleportToOwner(owner)) {
            maid.getNavigationManager().resetNavigation();
            maid.getSwimManager().setGoingToBreath(false);
            maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
            this.m_22562_(worldIn, (LivingEntity)maid, gameTimeIn);
            return;
        }
        int startDistance = (int)maid.m_21535_() - 2;
        int minTeleportDistance = startDistance + 4;
        if (this.ownerStateConditions(owner, maid) && this.maidStateConditions(maid) && !maid.m_19950_((Entity)owner, startDistance)) {
            if (!maid.m_19950_((Entity)owner, minTeleportDistance)) {
                maid.teleportToOwner(owner);
                maid.getNavigationManager().resetNavigation();
            } else if (!this.ownerIsWalkTarget(maid, owner)) {
                BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)owner, (float)this.speedModifier, (int)this.stopDistance);
            }
        }
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner, EntityMaid maid) {
        return owner != null && !owner.m_5833_() && !owner.m_21224_() && maid.f_19853_ == owner.f_19853_;
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, LivingEntity owner) {
        return maid.m_6274_().m_21952_(MemoryModuleType.f_26370_).map(target -> {
            PositionTracker patt3564$temp = target.m_26420_();
            if (patt3564$temp instanceof EntityTracker) {
                EntityTracker tracker = (EntityTracker)patt3564$temp;
                return tracker.m_147481_().equals((Object)owner);
            }
            return false;
        }).orElse(false);
    }
}

