/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MaidNodeEvaluator
extends WalkNodeEvaluator {
    public BlockPathTypes m_8086_(BlockGetter level, int pX, int pY, int pZ) {
        return this.getMaidBlockPathTypeStatic(level, new BlockPos.MutableBlockPos(pX, pY, pZ));
    }

    public int m_6065_(Node[] outputArray, Node node) {
        int nodeId = super.m_6065_(outputArray, node);
        return this.createClimbNode(nodeId, outputArray, node);
    }

    protected int createClimbNode(int nodeId, Node[] nodes, Node origin) {
        EntityMaid maid;
        Mob mob = this.f_77313_;
        if (mob instanceof EntityMaid && (maid = (EntityMaid)mob).getConfigManager().isActiveClimbing()) {
            BlockPos.MutableBlockPos downPos;
            BlockPos.MutableBlockPos upPos = new BlockPos.MutableBlockPos(origin.f_77271_, origin.f_77272_ + 1, origin.f_77273_);
            if (MaidNodeEvaluator.isMaidCanClimbBlock((BlockPos)upPos, maid)) {
                Node node = this.m_77349_((BlockPos)upPos);
                if (!node.f_77279_) {
                    node.f_77281_ = 0.0f;
                    node.f_77282_ = BlockPathTypes.WALKABLE;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
            if (MaidNodeEvaluator.isMaidCanClimbBlock((BlockPos)(downPos = new BlockPos.MutableBlockPos(origin.f_77271_, origin.f_77272_ - 1, origin.f_77273_)), maid)) {
                Node node = this.m_77349_((BlockPos)downPos);
                if (!node.f_77279_) {
                    node.f_77281_ = 0.0f;
                    node.f_77282_ = BlockPathTypes.WALKABLE;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
        }
        return nodeId;
    }

    private BlockPathTypes getMaidBlockPathTypeStatic(BlockGetter level, BlockPos.MutableBlockPos pos) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPathTypes type = this.getMaidBlockPathTypeRaw(level, (BlockPos)pos);
        if (type == BlockPathTypes.OPEN && y >= level.m_141937_() + 1) {
            BlockPathTypes typeBelow = this.getMaidBlockPathTypeRaw(level, (BlockPos)pos.m_122178_(x, y - 1, z));
            BlockPathTypes blockPathTypes = type = typeBelow != BlockPathTypes.WALKABLE && typeBelow != BlockPathTypes.OPEN && typeBelow != BlockPathTypes.WATER && typeBelow != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            if (typeBelow == BlockPathTypes.DAMAGE_FIRE) {
                type = BlockPathTypes.DAMAGE_FIRE;
            }
            if (typeBelow == BlockPathTypes.DAMAGE_OTHER) {
                type = BlockPathTypes.DAMAGE_OTHER;
            }
            if (typeBelow == BlockPathTypes.STICKY_HONEY) {
                type = BlockPathTypes.STICKY_HONEY;
            }
            if (typeBelow == BlockPathTypes.POWDER_SNOW) {
                type = BlockPathTypes.DANGER_POWDER_SNOW;
            }
            if (typeBelow == BlockPathTypes.DAMAGE_CAUTIOUS) {
                type = BlockPathTypes.DAMAGE_CAUTIOUS;
            }
        }
        if (type == BlockPathTypes.WALKABLE) {
            type = MaidNodeEvaluator.m_77607_((BlockGetter)level, (BlockPos.MutableBlockPos)pos.m_122178_(x, y, z), (BlockPathTypes)type);
        }
        return type;
    }

    private BlockPathTypes getMaidBlockPathTypeRaw(BlockGetter level, BlockPos pos) {
        EntityMaid maid;
        Mob mob;
        EntityMaid maid2;
        Mob mob2 = this.f_77313_;
        if (mob2 instanceof EntityMaid && (maid2 = (EntityMaid)mob2).m_21533_() && !maid2.m_21444_(pos)) {
            return BlockPathTypes.BLOCKED;
        }
        BlockState blockState = level.m_8055_(pos);
        BlockPathTypes pathType = blockState.getBlockPathType(level, pos, null);
        if (pathType != null) {
            return pathType;
        }
        if (blockState.m_60795_()) {
            return BlockPathTypes.OPEN;
        }
        if (blockState.m_60734_() instanceof FenceGateBlock) {
            pathType = (Boolean)blockState.m_61143_((Property)FenceGateBlock.f_53341_) != false ? BlockPathTypes.DOOR_OPEN : BlockPathTypes.DOOR_WOOD_CLOSED;
        } else {
            mob = this.f_77313_;
            if (mob instanceof EntityMaid && this.canClimb(blockState, pos, maid = (EntityMaid)mob)) {
                pathType = BlockPathTypes.WALKABLE;
            } else {
                pathType = WalkNodeEvaluator.m_77643_((BlockGetter)level, (BlockPos)pos);
                if (!this.heightCheckExclusions(pathType)) {
                    VoxelShape shape = blockState.m_60812_(level, pos);
                    if (pathType != BlockPathTypes.BLOCKED && shape.m_83297_(Direction.Axis.Y) - shape.m_83288_(Direction.Axis.Y) > 0.5) {
                        pathType = BlockPathTypes.BLOCKED;
                    }
                }
            }
        }
        if (pathType == BlockPathTypes.DOOR_WOOD_CLOSED && (mob = this.f_77313_) instanceof EntityMaid) {
            maid = (EntityMaid)mob;
            if (!this.canOpenDoor(blockState.m_60734_(), maid)) {
                pathType = BlockPathTypes.DOOR_IRON_CLOSED;
            }
        }
        return pathType;
    }

    private boolean heightCheckExclusions(BlockPathTypes pathType) {
        return pathType == BlockPathTypes.DOOR_OPEN || pathType == BlockPathTypes.DOOR_WOOD_CLOSED;
    }

    private boolean canOpenDoor(Block block, EntityMaid maid) {
        if (block instanceof DoorBlock) {
            return maid.getConfigManager().isOpenDoor();
        }
        if (block instanceof FenceGateBlock) {
            return maid.getConfigManager().isOpenFenceGate();
        }
        return true;
    }

    private boolean canClimb(BlockState blockState, BlockPos blockPos, EntityMaid maid) {
        if (MaidNodeEvaluator.isMaidCanClimbBlock(blockState, blockPos, maid)) {
            return maid.getConfigManager().isActiveClimbing();
        }
        return false;
    }

    public static boolean isMaidCanClimbBlock(BlockPos blockPos, EntityMaid maid) {
        Level level = maid.f_19853_;
        BlockState blockState = level.m_8055_(blockPos);
        return MaidNodeEvaluator.isMaidCanClimbBlock(blockState, blockPos, maid);
    }

    public static boolean isMaidCanClimbBlock(BlockState blockState, BlockPos blockPos, EntityMaid maid) {
        return blockState.isLadder((LevelReader)maid.f_19853_, blockPos, (LivingEntity)maid);
    }
}

