/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class OpenMaidGuiMessage {
    private final int entityId;
    private final int tabId;

    public OpenMaidGuiMessage(int entityId, int tabId) {
        this.entityId = entityId;
        this.tabId = tabId;
    }

    public OpenMaidGuiMessage(int entityId) {
        this(entityId, 0);
    }

    public static void encode(OpenMaidGuiMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.entityId);
        buf.m_130130_(message.tabId);
    }

    public static OpenMaidGuiMessage decode(FriendlyByteBuf buf) {
        int entityId = buf.m_130242_();
        int tabId = buf.m_130242_();
        return new OpenMaidGuiMessage(entityId, tabId);
    }

    public static void handle(OpenMaidGuiMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> OpenMaidGuiMessage.handle(message, ((NetworkEvent.Context)contextSupplier.get()).getSender()));
        }
        context.setPacketHandled(true);
    }

    private static void handle(OpenMaidGuiMessage message, @Nullable ServerPlayer player) {
        EntityMaid maid;
        if (player == null) {
            return;
        }
        Entity entity = player.f_19853_.m_6815_(message.entityId);
        if (entity instanceof EntityMaid && OpenMaidGuiMessage.stillValid((Player)player, maid = (EntityMaid)entity)) {
            maid.openMaidGui((Player)player, message.tabId);
        }
    }

    private static boolean stillValid(Player playerIn, EntityMaid maid) {
        return maid.m_21830_((LivingEntity)playerIn) && !maid.m_5803_() && maid.m_6084_() && maid.m_20270_((Entity)playerIn) < 5.0f;
    }
}

