/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import com.supermartijn642.trashcans.TrashCans;
import com.supermartijn642.trashcans.packet.PacketChangeEnergyLimit;
import com.supermartijn642.trashcans.packet.PacketToggleEnergyLimit;
import com.supermartijn642.trashcans.screen.ArrowButton;
import com.supermartijn642.trashcans.screen.CheckBox;
import com.supermartijn642.trashcans.screen.EnergyTrashCanContainer;
import com.supermartijn642.trashcans.screen.TrashCanScreen;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class EnergyTrashCanScreen
extends TrashCanScreen<EnergyTrashCanContainer> {
    private CheckBox checkBox;
    private ArrowButton leftArrow;
    private ArrowButton rightArrow;
    private boolean shift;
    private boolean control;

    public EnergyTrashCanScreen() {
        super("trashcans.gui.energy_trash_can.title");
    }

    protected void addWidgets(TrashCanBlockEntity entity) {
        this.checkBox = (CheckBox)this.addWidget((Widget)new CheckBox(21, 66, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketToggleEnergyLimit(((EnergyTrashCanContainer)this.container).getBlockEntityPos()))));
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(49, 66, true, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((EnergyTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? -1 : -100) : (this.control ? -10000 : -1000)))));
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow = (ArrowButton)this.addWidget((Widget)new ArrowButton(170, 66, false, () -> TrashCans.CHANNEL.sendToServer((BasePacket)new PacketChangeEnergyLimit(((EnergyTrashCanContainer)this.container).getBlockEntityPos(), this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)))));
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    protected void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY, TrashCanBlockEntity entity) {
        super.renderTooltips(context, mouseX, mouseY, (Object)entity);
        if (this.leftArrow.isFocused() && this.leftArrow.isActive()) {
            Object[] objectArray = new Component[4];
            objectArray[0] = TextComponents.string((String)("-" + (this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)))).get();
            objectArray[1] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change1", (Object[])new Object[]{"-100"}).color(ChatFormatting.AQUA).get();
            objectArray[2] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change2", (Object[])new Object[]{"-10000"}).color(ChatFormatting.AQUA).get();
            objectArray[3] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change3", (Object[])new Object[]{"-1"}).color(ChatFormatting.AQUA).get();
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (List)Lists.newArrayList((Object[])objectArray), (int)mouseX, (int)mouseY);
        }
        if (this.rightArrow.isFocused() && this.rightArrow.isActive()) {
            Object[] objectArray = new Component[4];
            objectArray[0] = TextComponents.string((String)("+" + (this.shift ? (this.control ? 1 : 100) : (this.control ? 10000 : 1000)))).get();
            objectArray[1] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change1", (Object[])new Object[]{"+100"}).color(ChatFormatting.AQUA).get();
            objectArray[2] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change2", (Object[])new Object[]{"+10000"}).color(ChatFormatting.AQUA).get();
            objectArray[3] = TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit.change3", (Object[])new Object[]{"+1"}).color(ChatFormatting.AQUA).get();
            ScreenUtils.drawTooltip((PoseStack)context.poseStack(), (List)Lists.newArrayList((Object[])objectArray), (int)mouseX, (int)mouseY);
        }
    }

    protected void update(TrashCanBlockEntity entity) {
        super.update((Object)entity);
        this.checkBox.update(entity.useEnergyLimit);
        this.leftArrow.setActive(entity.useEnergyLimit);
        this.rightArrow.setActive(entity.useEnergyLimit);
    }

    @Override
    protected String getBackground() {
        return "energy_screen.png";
    }

    @Override
    protected void drawText(PoseStack poseStack, TrashCanBlockEntity entity) {
        ScreenUtils.drawString((PoseStack)poseStack, (Component)TextComponents.translation((String)"trashcans.gui.energy_trash_can.limit").get(), (float)8.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((PoseStack)poseStack, (Component)TextComponents.string((String)I18n.m_118938_((String)"trashcans.gui.energy_trash_can.value", (Object[])new Object[0]).replace("$number$", "" + entity.energyLimit)).get(), (float)114.0f, (float)71.0f);
    }

    protected boolean keyPressed(int keyCode, boolean hasBeenHandled, TrashCanBlockEntity object) {
        if (keyCode == 340) {
            this.shift = true;
        } else if (keyCode == 341) {
            this.control = true;
        }
        return super.keyPressed(keyCode, hasBeenHandled, (Object)object);
    }

    protected boolean keyReleased(int keyCode, boolean hasBeenHandled, TrashCanBlockEntity object) {
        if (keyCode == 340) {
            this.shift = false;
        } else if (keyCode == 341) {
            this.control = false;
        }
        return super.keyReleased(keyCode, hasBeenHandled, (Object)object);
    }
}

