/*
 * Decompiled with CFR 0.152.
 */
package weather2.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import weather2.WeatherBlocks;
import weather2.util.WeatherUtilEntity;
import weather2.util.WindReader;

public class WindVaneBlockEntity
extends BlockEntity {
    public float smoothAngle = 0.0f;
    public float smoothAnglePrev = 0.0f;
    public float smoothAngleRotationalVelAccel = 0.0f;
    public boolean isOutsideCached = false;

    public WindVaneBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)WeatherBlocks.BLOCK_ENTITY_WIND_VANE.get(), p_155229_, p_155230_);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WindVaneBlockEntity entity) {
        entity.tick(level, pos, state);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.f_46443_) {
            if (level.m_46467_() % 40L == 0L) {
                this.isOutsideCached = WeatherUtilEntity.isPosOutside(level, new Vec3((double)((float)this.m_58899_().m_123341_() + 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.5f), (double)((float)this.m_58899_().m_123343_() + 0.5f)), false, true);
            }
            if (this.isOutsideCached) {
                float targetAngle = WindReader.getWindAngle(level, new Vec3((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()));
                float windSpeed = WindReader.getWindSpeed(level, pos, 1.0f);
                if (this.smoothAngle > 180.0f) {
                    this.smoothAngle -= 360.0f;
                }
                if (this.smoothAngle < -180.0f) {
                    this.smoothAngle += 360.0f;
                }
                if (this.smoothAnglePrev > 180.0f) {
                    this.smoothAnglePrev -= 360.0f;
                }
                if (this.smoothAnglePrev < -180.0f) {
                    this.smoothAnglePrev += 360.0f;
                }
                this.smoothAnglePrev = this.smoothAngle;
                float bestMove = Mth.m_14177_((float)(targetAngle - this.smoothAngle));
                if (Math.abs(bestMove) < 180.0f) {
                    if (bestMove > 0.0f) {
                        this.smoothAngleRotationalVelAccel = (float)((double)this.smoothAngleRotationalVelAccel - (double)windSpeed * 0.4);
                    }
                    if (bestMove < 0.0f) {
                        this.smoothAngleRotationalVelAccel = (float)((double)this.smoothAngleRotationalVelAccel + (double)windSpeed * 0.4);
                    }
                    if ((double)this.smoothAngleRotationalVelAccel > 0.3 || (double)this.smoothAngleRotationalVelAccel < -0.3) {
                        this.smoothAngle += this.smoothAngleRotationalVelAccel;
                    }
                    this.smoothAngleRotationalVelAccel *= 0.96f;
                }
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
    }
}

