/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import com.corosus.coroutil.util.CoroUtilBlock;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import weather2.ClientTickHandler;
import weather2.Weather;
import weather2.config.ClientConfigData;
import weather2.config.ConfigMisc;
import weather2.config.ConfigSound;
import weather2.config.ConfigStorm;
import weather2.config.ConfigTornado;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilBlock;
import weather2.util.WeatherUtilEntity;
import weather2.util.WeatherUtilSound;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.StormObject;
import weather2.weathersystem.tornado.simple.Layer;
import weather2.weathersystem.tornado.simple.TornadoFunnelSimple;

public class TornadoHelper {
    public StormObject storm;
    public int ripCount = 0;
    public long lastGrabTime = 0L;
    public int tickGrabCount = 0;
    public int removeCount = 0;
    public int tryRipCount = 0;
    public int tornadoBaseSize = 5;
    public int grabDist = 100;
    public boolean lastTickPlayerClose;
    private HashMap<BlockPos, BlockUpdateSnapshot> listBlockUpdateQueue = new HashMap();
    private int queueProcessRate = 40;
    public static boolean isOutsideCached = false;
    public boolean isBlockGrabbingBlockedCached = true;
    public long isBlockGrabbingBlockedCached_LastCheck = 0L;
    public static GameProfile fakePlayerProfile = null;

    public TornadoHelper(StormObject parStorm) {
        this.storm = parStorm;
    }

    public int getTornadoBaseSize() {
        int sizeChange = 10;
        if (this.storm.isPlayerControlled() && this.storm.isBaby()) {
            return 8;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE5) {
            return sizeChange * 9;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE4) {
            return sizeChange * 7;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE3) {
            return sizeChange * 5;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE2) {
            return sizeChange * 4;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE1) {
            return sizeChange * 3;
        }
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
            return sizeChange * 1;
        }
        return 5;
    }

    public void tick(Level parWorld) {
        if (!parWorld.m_5776_() && parWorld.m_46467_() % (long)this.queueProcessRate == 0L) {
            for (BlockUpdateSnapshot snapshot : this.listBlockUpdateQueue.values()) {
                ServerLevel world = WeatherUtil.getWorld(snapshot.getDimension());
                if (world == null) continue;
                world.m_7731_(snapshot.getPos(), snapshot.getState(), 3);
                if (!snapshot.isCreateEntityForBlockRemoval()) continue;
            }
            this.listBlockUpdateQueue.clear();
        }
        if (this.storm == null) {
            return;
        }
        boolean seesLight = false;
        this.tickGrabCount = 0;
        this.removeCount = 0;
        this.tryRipCount = 0;
        int tryRipMax = 300;
        if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE5) {
            tryRipMax = (int)((double)tryRipMax * 2.5);
        } else if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE4) {
            tryRipMax = (int)((double)tryRipMax * 1.8);
        } else if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE3) {
            tryRipMax = (int)((double)tryRipMax * 1.5);
        } else if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE2) {
            tryRipMax = (int)((double)tryRipMax * 1.2);
        }
        int firesPerTickMax = 1;
        this.tornadoBaseSize = this.getTornadoBaseSize();
        if (this.storm.stormType == StormObject.TYPE_WATER) {
            this.tornadoBaseSize *= 3;
        }
        this.forceRotate(parWorld);
        Random rand = new Random();
        if (!parWorld.m_5776_() && !Weather.isLoveTropicsInstalled() && (ConfigTornado.Storm_Tornado_grabBlocks || this.storm.isFirenado)) {
            boolean yStart = false;
            int yEnd = (int)this.storm.pos.f_82480_;
            boolean yInc = true;
            Biome bgb = (Biome)parWorld.m_204166_(new BlockPos((Vec3i)WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(Mth.m_14107_((double)this.storm.pos.f_82479_), 0, Mth.m_14107_((double)this.storm.pos.f_82481_))))).get();
            double depth = 0.0;
            if (bgb != null && (depth <= 0.7 || this.storm.isFirenado)) {
                boolean newTest = false;
                int tryCount = 0;
                if (newTest) {
                    TornadoFunnelSimple tornadoFunnelSimple = this.storm.getTornadoFunnelSimple();
                    int layers = tornadoFunnelSimple.listLayers.size();
                    for (int i = 0; i < layers; ++i) {
                        float radius = tornadoFunnelSimple.getConfig().getRadiusOfBase() + tornadoFunnelSimple.getConfig().getRadiusIncreasePerLayer() * (float)i;
                        Layer layer = tornadoFunnelSimple.listLayers.get(i);
                        float circumference = radius * 2.0f * (float)Math.PI;
                        float particleSpaceOccupy = 1.0f;
                        float scanResolution = (float)Math.floor(circumference / particleSpaceOccupy);
                        float particleSpacingDegrees = 360.0f / scanResolution;
                        for (float deg = 0.0f; deg < 360.0f; deg += particleSpacingDegrees) {
                            float radiusScanSize = 5.0f;
                            for (float radiusToUse = radius; radiusToUse <= radius; radiusToUse += 1.0f) {
                                float x = (float)(layer.getPos().f_82479_ + -Math.sin(Math.toRadians(deg)) * (double)radiusScanSize);
                                float z = (float)(layer.getPos().f_82481_ + Math.cos(Math.toRadians(deg)) * (double)radiusScanSize);
                                float y = (float)layer.getPos().f_82480_;
                                pos = new BlockPos((int)Math.floor(x), (int)Math.floor(y) - 1, (int)Math.floor(z));
                                boolean performed = false;
                                BlockState state = parWorld.m_8055_(pos);
                                if (parWorld.m_46467_() % 10L != 0L || radiusToUse == radius - radiusScanSize) {
                                    // empty if block
                                }
                                ++tryCount;
                                if (this.canGrab(parWorld, state, pos)) {
                                    ++this.tryRipCount;
                                    performed = seesLight = this.tryRip(parWorld, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                                }
                                if (performed || !ConfigTornado.Storm_Tornado_RefinedGrabRules || state.m_60734_() != Blocks.f_50440_ || this.listBlockUpdateQueue.containsKey(pos)) continue;
                                this.listBlockUpdateQueue.put(pos, new BlockUpdateSnapshot((ResourceKey<Level>)parWorld.m_46472_(), Blocks.f_50493_.m_49966_(), state, pos, false));
                            }
                        }
                    }
                } else {
                    BlockState state;
                    double dist;
                    double d2;
                    double d0;
                    int tryZ;
                    int ii = 2;
                    int stageIntensity = (int)((float)(this.storm.levelCurIntensityStage + 1) - StormObject.levelStormIntensityFormingStartVal);
                    int loopAmount = stageIntensity * 500;
                    if (this.storm.stormType == StormObject.TYPE_WATER) {
                        loopAmount = 1 + ii / 2;
                    }
                    for (int k = 0; k < loopAmount && this.tryRipCount <= tryRipMax; ++k) {
                        int tryY;
                        int topY;
                        int bottomY = (int)Math.max((double)parWorld.m_141937_(), this.storm.posBaseFormationPos.f_82480_ - 10.0);
                        if (bottomY >= (topY = (int)Math.max((double)parWorld.m_151558_(), this.storm.getPosTop().f_82480_))) {
                            bottomY = topY - 1;
                        }
                        if ((tryY = rand.nextInt(bottomY, topY)) > parWorld.m_151558_()) {
                            tryY = parWorld.m_151558_();
                        }
                        int tryX = (int)this.storm.pos.f_82479_ + rand.nextInt(this.tornadoBaseSize + ii) - (this.tornadoBaseSize / 2 + ii / 2);
                        tryZ = (int)this.storm.pos.f_82481_ + rand.nextInt(this.tornadoBaseSize + ii) - (this.tornadoBaseSize / 2 + ii / 2);
                        d0 = this.storm.pos.f_82479_ - (double)tryX;
                        d2 = this.storm.pos.f_82481_ - (double)tryZ;
                        dist = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                        pos = new BlockPos(tryX, tryY, tryZ);
                        if (!(dist < (double)(this.tornadoBaseSize / 2 + ii / 2)) || this.tryRipCount >= tryRipMax) continue;
                        state = parWorld.m_8055_(pos);
                        Block blockID = state.m_60734_();
                        boolean performed = false;
                        ++tryCount;
                        if (this.canGrab(parWorld, state, pos)) {
                            ++this.tryRipCount;
                            performed = seesLight = this.tryRip(parWorld, tryX, tryY, tryZ);
                        }
                        if (performed || !ConfigTornado.Storm_Tornado_RefinedGrabRules || blockID != Blocks.f_50440_ || this.listBlockUpdateQueue.containsKey(pos)) continue;
                        this.listBlockUpdateQueue.put(pos, new BlockUpdateSnapshot((ResourceKey<Level>)parWorld.m_46472_(), Blocks.f_50493_.m_49966_(), state, pos, false));
                    }
                    int spawnYOffset = (int)this.storm.posBaseFormationPos.f_82480_ - 10;
                    for (int k = 0; k < 10; ++k) {
                        int randSize = 40;
                        randSize = 10;
                        int tryX = (int)this.storm.pos.f_82479_ + rand.nextInt(randSize) - randSize / 2;
                        int tryY = spawnYOffset - 2 + rand.nextInt(8);
                        d0 = this.storm.pos.f_82479_ - (double)tryX;
                        tryZ = (int)this.storm.pos.f_82481_ + rand.nextInt(randSize) - randSize / 2;
                        d2 = this.storm.pos.f_82481_ - (double)tryZ;
                        dist = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                        if (!(dist < (double)(this.tornadoBaseSize / 2 + randSize / 2)) || this.tryRipCount >= tryRipMax) continue;
                        pos = new BlockPos(tryX, tryY, tryZ);
                        state = parWorld.m_8055_(pos);
                        ++tryCount;
                        if (!this.canGrab(parWorld, state, pos)) continue;
                        ++this.tryRipCount;
                        this.tryRip(parWorld, tryX, tryY, tryZ);
                    }
                }
            }
        } else {
            seesLight = true;
        }
        if (!parWorld.m_5776_() && this.storm.isFirenado) {
            double d2;
            double d0;
            double dist;
            if (this.storm.levelCurIntensityStage >= StormObject.STATE_STAGE1) {
                for (int i = 0; i < firesPerTickMax; ++i) {
                    BlockPos posUp = CoroUtilBlock.blockPos((double)this.storm.posGround.f_82479_, (double)(this.storm.posGround.f_82480_ + (double)rand.nextInt(30)), (double)this.storm.posGround.f_82481_);
                    BlockState state = parWorld.m_8055_(posUp);
                    if (!CoroUtilBlock.isAir((Block)state.m_60734_())) continue;
                }
            }
            int randSize = 10;
            int tryX = (int)this.storm.pos.f_82479_ + rand.nextInt(randSize) - randSize / 2;
            int tryZ = (int)this.storm.pos.f_82481_ + rand.nextInt(randSize) - randSize / 2;
            int tryY = parWorld.m_6924_(Heightmap.Types.MOTION_BLOCKING, tryX, tryZ) - 1;
            int funnelBottomY = (int)this.storm.pos.f_82480_;
            if (this.storm.getTornadoFunnelSimple().listLayers.size() > 0) {
                Layer layer = this.storm.getTornadoFunnelSimple().listLayers.get(0);
                funnelBottomY = (int)layer.getPos().m_7098_();
            }
            if (tryY > funnelBottomY - 3 && (dist = (double)Mth.m_14116_((float)((float)((d0 = this.storm.pos.f_82479_ - (double)tryX) * d0 + (d2 = this.storm.pos.f_82481_ - (double)tryZ) * d2)))) < (double)(this.tornadoBaseSize / 2 + randSize / 2) && this.tryRipCount < tryRipMax) {
                BlockPos pos = new BlockPos(tryX, tryY, tryZ);
                Block block = parWorld.m_8055_(pos).m_60734_();
                BlockPos posUp = new BlockPos(tryX, tryY + 1, tryZ);
                Block blockUp = parWorld.m_8055_(posUp).m_60734_();
                if (!CoroUtilBlock.isAir((Block)block) && CoroUtilBlock.isAir((Block)blockUp)) {
                    parWorld.m_7731_(posUp, Blocks.f_50083_.m_49966_(), 3);
                }
            }
        }
    }

    public boolean isNoDigCoord(int x, int y, int z) {
        return false;
    }

    public boolean tryRip(Level parWorld, int tryX, int tryY, int tryZ) {
        boolean tryRip = true;
        BlockPos pos = new BlockPos(tryX, tryY, tryZ);
        if (this.listBlockUpdateQueue.containsKey(pos)) {
            return true;
        }
        if (!tryRip) {
            return true;
        }
        if (!ConfigTornado.Storm_Tornado_grabBlocks) {
            return true;
        }
        if (this.isNoDigCoord(tryX, tryY, tryZ)) {
            return true;
        }
        boolean seesLight = false;
        BlockState state = parWorld.m_8055_(pos);
        Block blockID = state.m_60734_();
        if (WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX, 0, tryZ)).m_123342_() - 1 == tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX + 1, 0, tryZ)).m_123342_() - 1 < tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX, 0, tryZ + 1)).m_123342_() - 1 < tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX - 1, 0, tryZ)).m_123342_() - 1 < tryY || WeatherUtilBlock.getPrecipitationHeightSafe(parWorld, new BlockPos(tryX, 0, tryZ - 1)).m_123342_() - 1 < tryY) {
            int blockCount = 0;
            if (parWorld.m_46749_(CoroUtilBlock.blockPos((double)this.storm.pos.f_82479_, (double)128.0, (double)this.storm.pos.f_82481_)) && this.lastGrabTime < System.currentTimeMillis() && this.tickGrabCount < ConfigTornado.Storm_Tornado_maxBlocksGrabbedPerTick) {
                this.lastGrabTime = System.currentTimeMillis() - 5L;
                if (blockID != Blocks.f_50354_ && blockID != Blocks.f_50126_ && blockID != Blocks.f_50127_ && blockID != Blocks.f_50125_ && blockID != Blocks.f_152499_) {
                    boolean playerClose;
                    boolean bl = playerClose = parWorld.m_45924_(this.storm.posBaseFormationPos.f_82479_, this.storm.posBaseFormationPos.f_82480_, this.storm.posBaseFormationPos.f_82481_, 140.0, false) != null;
                    if (playerClose) {
                        ++this.tickGrabCount;
                        ++this.ripCount;
                        seesLight = true;
                    }
                    if (WeatherUtil.shouldRemoveBlock(state)) {
                        ++this.removeCount;
                        boolean shouldEntityify = blockCount <= ConfigTornado.Storm_Tornado_maxFlyingEntityBlocks;
                        this.listBlockUpdateQueue.put(pos, new BlockUpdateSnapshot((ResourceKey<Level>)parWorld.m_46472_(), Blocks.f_50016_.m_49966_(), state, pos, playerClose && shouldEntityify));
                        if (playerClose && shouldEntityify && (state.m_60815_() || state.m_60734_().m_284356_() == MapColor.f_283915_)) {
                            ((WeatherManagerServer)this.storm.manager).syncBlockParticleNew(pos, state, this.storm);
                        }
                    }
                }
                if (blockID == Blocks.f_50058_) {
                    parWorld.m_5594_(null, new BlockPos(tryX, tryY, tryZ), SoundEvents.f_11983_, SoundSource.AMBIENT, 5.0f, 1.0f);
                }
            }
        }
        return seesLight;
    }

    public boolean canGrab(Level parWorld, BlockState state, BlockPos pos) {
        if (!CoroUtilBlock.isAir((Block)state.m_60734_()) && state.m_60734_() != Blocks.f_50083_ && WeatherUtil.shouldGrabBlock(parWorld, state) && !this.isBlockGrabbingBlocked(parWorld, state, pos)) {
            return this.canGrabEventCheck(parWorld, state, pos);
        }
        return false;
    }

    public boolean canGrabEventCheck(Level world, BlockState state, BlockPos pos) {
        if (!ConfigMisc.blockBreakingInvokesCancellableEvent) {
            return true;
        }
        if (world instanceof ServerLevel) {
            if (fakePlayerProfile == null) {
                fakePlayerProfile = new GameProfile(UUID.fromString("1396b887-2570-4948-86e9-0633d1d22946"), "weather2FakePlayer");
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (Player)FakePlayerFactory.get((ServerLevel)((ServerLevel)world), (GameProfile)fakePlayerProfile));
            MinecraftForge.EVENT_BUS.post((Event)event);
            return !event.isCanceled();
        }
        return false;
    }

    public boolean canGrabEntity(Entity ent) {
        if (ent.m_9236_().m_5776_()) {
            return this.canGrabEntityClient(ent);
        }
        if (ent instanceof Player) {
            if (!((Player)ent).m_7500_()) {
                if (ConfigTornado.Storm_Tornado_grabPlayer) {
                    return !this.storm.isPlayerControlled() || this.storm.spawnerUUID == null || !this.storm.spawnerUUID.equals(ent.m_20148_().toString());
                }
                return false;
            }
            return false;
        }
        if (ConfigTornado.Storm_Tornado_grabPlayersOnly) {
            return false;
        }
        if (ent instanceof Npc) {
            return ConfigTornado.Storm_Tornado_grabVillagers;
        }
        if (ent instanceof ItemEntity) {
            return ConfigTornado.Storm_Tornado_grabItems || this.storm.isPet();
        }
        if (ent instanceof Enemy) {
            return ConfigTornado.Storm_Tornado_grabMobs;
        }
        if (ent instanceof Animal) {
            return ConfigTornado.Storm_Tornado_grabAnimals;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canGrabEntityClient(Entity ent) {
        ClientConfigData clientConfig = ClientTickHandler.clientConfigData;
        if (ent instanceof Player) {
            if (!((Player)ent).m_7500_()) {
                if (ConfigTornado.Storm_Tornado_grabPlayer) {
                    return !this.storm.isPlayerControlled() || this.storm.spawnerUUID == null || !this.storm.spawnerUUID.equals(ent.m_20148_().toString());
                }
                return false;
            }
            return false;
        }
        if (clientConfig.Storm_Tornado_grabPlayersOnly) {
            return false;
        }
        if (ent instanceof Npc) {
            return clientConfig.Storm_Tornado_grabVillagers;
        }
        if (ent instanceof ItemEntity) {
            return clientConfig.Storm_Tornado_grabItems || this.storm.isPet();
        }
        if (ent instanceof Enemy) {
            return clientConfig.Storm_Tornado_grabMobs;
        }
        if (ent instanceof Animal) {
            return clientConfig.Storm_Tornado_grabAnimals;
        }
        return true;
    }

    public boolean forceRotate(Level parWorld) {
        return this.forceRotate(parWorld, false);
    }

    public boolean forceRotate(Level parWorld, boolean featherFallInstead) {
        double dist = this.grabDist * 2;
        if (this.storm.isPet()) {
            dist = 3.0;
        }
        AABB aabb = new AABB(this.storm.pos.f_82479_, (double)this.storm.currentTopYBlock, this.storm.pos.f_82481_, this.storm.pos.f_82479_, (double)this.storm.currentTopYBlock, this.storm.pos.f_82481_);
        aabb = this.storm.isPet() ? aabb.m_82377_(dist, 3.0, dist) : aabb.m_82377_(dist, (double)this.storm.maxHeight * 3.8, dist);
        List list = parWorld.m_45976_(Entity.class, aabb);
        boolean foundEnt = false;
        boolean killCount = false;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (!this.canGrabEntity(entity1) || !(this.getDistanceXZ(this.storm.posBaseFormationPos, entity1.m_20185_(), entity1.m_20186_(), entity1.m_20189_()) < dist)) continue;
                if (!this.storm.isPet()) {
                    if (entity1 instanceof Player) {
                        if (!WeatherUtilEntity.isEntityOutside(entity1) && (!this.storm.isPlayerControlled() || !WeatherUtilEntity.canPosSeePos(parWorld, entity1.m_20182_(), this.storm.posGround))) continue;
                        if (featherFallInstead) {
                            ((Player)entity1).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 600, 0, false, true, true));
                        } else {
                            this.storm.spinEntityv2(entity1);
                        }
                        foundEnt = true;
                        continue;
                    }
                    if (!(entity1 instanceof LivingEntity) || !WeatherUtilEntity.isEntityOutside(entity1, false) && (!this.storm.isPlayerControlled() || !WeatherUtilEntity.canPosSeePos(parWorld, entity1.m_20182_(), this.storm.posGround))) continue;
                    if (featherFallInstead) {
                        ((LivingEntity)entity1).m_7292_(new MobEffectInstance(MobEffects.f_19591_, 600, 0, false, true, true));
                    } else {
                        this.storm.spinEntityv2(entity1);
                    }
                    foundEnt = true;
                    continue;
                }
                if (!(entity1 instanceof ItemEntity) || !this.storm.isPetGrabsItems()) continue;
                this.storm.spinEntityv2(entity1);
                foundEnt = true;
            }
        }
        return foundEnt;
    }

    public double getDistanceXZ(Vec3 parVec, double var1, double var3, double var5) {
        double var7 = parVec.f_82479_ - var1;
        double var11 = parVec.f_82481_ - var5;
        return Mth.m_14116_((float)((float)(var7 * var7 + var11 * var11)));
    }

    public double getDistanceXZ(Entity ent, double var1, double var3, double var5) {
        double var7 = ent.m_20185_() - var1;
        double var11 = ent.m_20189_() - var5;
        return Mth.m_14116_((float)((float)(var7 * var7 + var11 * var11)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void soundUpdates(boolean playFarSound, boolean playNearSound) {
        if (this.storm.isPet()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        int far = 200;
        int close = 120;
        if (this.storm.stormType == StormObject.TYPE_WATER) {
            close = 200;
        }
        Vec3 plPos = new Vec3(mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_());
        float quietTornadoTweak = 1.0f;
        float quietAmbientTweak = 1.0f;
        if (Weather.isLoveTropicsInstalled()) {
            if (this.storm.isPlayerControlled()) {
                quietTornadoTweak = 0.25f;
                quietAmbientTweak = 0.1f;
            }
            close = 7;
        }
        double distToPlayer = this.storm.posGround.m_82554_(plPos);
        float volScaleFar = (float)(((double)far - distToPlayer) / (double)far);
        float volScaleClose = (float)(((double)close - distToPlayer) / (double)close);
        if (volScaleFar < 0.0f) {
            volScaleFar = 0.0f;
        }
        if (volScaleClose < 0.0f) {
            volScaleClose = 0.0f;
        }
        this.lastTickPlayerClose = distToPlayer < (double)close;
        if (distToPlayer < (double)far) {
            if (playFarSound) {
                if (mc.f_91073_.m_46467_() % 40L == 0L) {
                    isOutsideCached = WeatherUtilEntity.isPosOutside((Level)mc.f_91073_, new Vec3(mc.f_91074_.m_20318_(1.0f).m_7096_() + 0.5, mc.f_91074_.m_20318_(1.0f).m_7098_() + 0.5, mc.f_91074_.m_20318_(1.0f).m_7094_() + 0.5));
                }
                if (isOutsideCached) {
                    this.tryPlaySound(WeatherUtilSound.snd_wind_far, 2, (Entity)mc.f_91074_, (float)((double)(volScaleFar * quietAmbientTweak) * ConfigSound.windyStormVolume), far);
                }
            }
            if (playNearSound) {
                this.tryPlaySound(WeatherUtilSound.snd_wind_close, 1, (Entity)mc.f_91074_, (float)((double)(volScaleClose * quietTornadoTweak) * ConfigSound.tornadoWindVolume), close);
            }
            if (this.storm.levelCurIntensityStage >= StormObject.STATE_FORMING) {
                if (this.storm.stormType == StormObject.TYPE_LAND) {
                    this.tryPlaySound(WeatherUtilSound.snd_tornado_dmg_close, 0, (Entity)mc.f_91074_, (float)((double)(volScaleClose * quietTornadoTweak) * ConfigSound.tornadoDamageVolume), close);
                }
            }
        }
    }

    public boolean tryPlaySound(String[] sound, int arrIndex, Entity source, float vol, float parCutOffRange) {
        Random rand = new Random();
        if (WeatherUtilSound.soundTimer[arrIndex] <= System.currentTimeMillis()) {
            WeatherUtilSound.playMovingSound(this.storm, "streaming." + sound[WeatherUtilSound.snd_rand[arrIndex]], vol, 1.0f, parCutOffRange);
            int length = WeatherUtilSound.soundToLength.get(sound[WeatherUtilSound.snd_rand[arrIndex]]);
            WeatherUtilSound.soundTimer[arrIndex] = System.currentTimeMillis() + (long)length - 500L;
            WeatherUtilSound.snd_rand[arrIndex] = rand.nextInt(3);
        }
        return false;
    }

    public boolean isBlockGrabbingBlocked(Level world, BlockState state, BlockPos pos) {
        int queryRate = 40;
        if (this.isBlockGrabbingBlockedCached_LastCheck + (long)queryRate < world.m_46467_()) {
            this.isBlockGrabbingBlockedCached_LastCheck = world.m_46467_();
            this.isBlockGrabbingBlockedCached = false;
            for (Long hash : this.storm.manager.getLookupWeatherBlockDamageDeflector().keySet()) {
                BlockPos posDeflect = BlockPos.m_122022_((long)hash);
                if (!(pos.m_123331_((Vec3i)posDeflect) < (double)(ConfigStorm.Storm_Deflector_RadiusOfStormRemoval * ConfigStorm.Storm_Deflector_RadiusOfStormRemoval))) continue;
                this.isBlockGrabbingBlockedCached = true;
                break;
            }
        }
        return this.isBlockGrabbingBlockedCached;
    }

    public void cleanup() {
        this.listBlockUpdateQueue.clear();
        this.storm = null;
    }

    public static class BlockUpdateSnapshot {
        private ResourceKey<Level> dimension;
        private BlockState state;
        private BlockState statePrev;
        private BlockPos pos;
        private boolean createEntityForBlockRemoval;

        public BlockUpdateSnapshot(ResourceKey<Level> dimension, BlockState state, BlockState statePrev, BlockPos pos, boolean createEntityForBlockRemoval) {
            this.dimension = dimension;
            this.state = state;
            this.statePrev = statePrev;
            this.pos = pos;
            this.createEntityForBlockRemoval = createEntityForBlockRemoval;
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public void setDimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        public BlockState getState() {
            return this.state;
        }

        public void setState(BlockState state) {
            this.state = state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public void setPos(BlockPos pos) {
            this.pos = pos;
        }

        public boolean isCreateEntityForBlockRemoval() {
            return this.createEntityForBlockRemoval;
        }

        public void setCreateEntityForBlockRemoval(boolean createEntityForBlockRemoval) {
            this.createEntityForBlockRemoval = createEntityForBlockRemoval;
        }

        public BlockState getStatePrev() {
            return this.statePrev;
        }

        public void setStatePrev(BlockState statePrev) {
            this.statePrev = statePrev;
        }
    }
}

