/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.entity.ai.witherstorm.head;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import nonamecrackers2.witherstormmod.common.entity.WitherStormEntity;
import nonamecrackers2.witherstormmod.common.entity.WitherStormSegmentEntity;
import nonamecrackers2.witherstormmod.common.entity.ai.witherstorm.head.AdditionalHead;
import nonamecrackers2.witherstormmod.common.entity.ai.witherstorm.head.MainHead;
import nonamecrackers2.witherstormmod.common.entity.ai.witherstorm.head.WitherStormHead;
import nonamecrackers2.witherstormmod.common.serializer.WitherStormModDataSerializers;
import nonamecrackers2.witherstormmod.common.util.HeadConfiguration;

public class HeadManager {
    public static final int TOTAL_HEADS = 3;
    public static final List<EntityDataAccessor<Boolean>> HEAD_ROARS = HeadManager.createDataAccessors(() -> WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false));
    public static final List<EntityDataAccessor<Boolean>> HEADS_BITING = HeadManager.createDataAccessors(() -> WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false));
    public static final List<EntityDataAccessor<Optional<Vec3>>> TARGETS = HeadManager.createDataAccessors(() -> WitherStormEntity.registerDataAccessor(WitherStormModDataSerializers.OPTIONAL_VECTOR_3D, Optional::empty));
    public static final List<EntityDataAccessor<Integer>> HURT_HEAD_TIME = HeadManager.createDataAccessors(() -> WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135028_, () -> 0));
    public static final List<EntityDataAccessor<Integer>> INJURE_ATTEMPT_COOLDOWN = HeadManager.createDataAccessors(() -> WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135028_, () -> 0));
    public static final List<EntityDataAccessor<Integer>> LOOK_STEPS = HeadManager.createDataAccessors(() -> WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135028_, () -> 3));
    public static final EntityDataAccessor<Integer> INJURY_TIME = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135028_, () -> 320);
    private static final EntityDataAccessor<Boolean> OTHER_HEADS_DISABLED = WitherStormEntity.registerDataAccessor(EntityDataSerializers.f_135035_, () -> false);
    private final List<HeadConfiguration> configurations;
    private final WitherStormEntity storm;
    private final Int2ObjectMap<WitherStormHead> heads = new Int2ObjectOpenHashMap();

    public HeadManager(WitherStormEntity storm, List<HeadConfiguration> configurations) {
        this.storm = storm;
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException("Head configurations cannot be empty!");
        }
        this.configurations = configurations;
        this.heads.put(0, (Object)new MainHead(storm, 0));
        for (int i = 1; i < storm.getTotalHeads(); ++i) {
            this.heads.put(i, (Object)new AdditionalHead(storm, i));
        }
    }

    private static <T> List<EntityDataAccessor<T>> createDataAccessors(Supplier<EntityDataAccessor<T>> registrar) {
        ImmutableList.Builder list = ImmutableList.builderWithExpectedSize((int)3);
        for (int i = 0; i < 3; ++i) {
            list.add(registrar.get());
        }
        return list.build();
    }

    public void update(int phase) {
        if (phase > 3) {
            this.setHeadInjuryTime(720);
        } else {
            this.setHeadInjuryTime(180);
        }
        this.heads.forEach((i, head) -> head.update(phase));
    }

    public void baseTick() {
        this.heads.forEach((i, head) -> head.baseTick(this.findCurrentConfig()));
    }

    public void tick() {
        this.heads.forEach((i, head) -> head.tick());
    }

    public void aiStep() {
        this.heads.forEach((i, head) -> head.doAi());
    }

    public void customServerAiStep() {
        this.heads.forEach((i, head) -> head.doServerAi());
    }

    private HeadConfiguration findCurrentConfig() {
        for (HeadConfiguration configuration : this.configurations) {
            if (!configuration.predicate().test(this.storm)) continue;
            return configuration;
        }
        return this.configurations.get(0);
    }

    public WitherStormHead getHead(int index) {
        return Objects.requireNonNull((WitherStormHead)this.heads.get(index), "No head exists with index " + index);
    }

    public List<WitherStormHead> getHeads() {
        return ImmutableList.copyOf((Collection)this.heads.values());
    }

    public List<AdditionalHead> getOtherHeads() {
        return this.heads.values().stream().filter(h -> h instanceof AdditionalHead).map(h -> (AdditionalHead)h).toList();
    }

    public PackedHeadRots packHeadRotations() {
        byte[] xHeadsRot = new byte[this.heads.size()];
        byte[] yHeadsRot = new byte[this.heads.size()];
        for (WitherStormHead head : this.getHeads()) {
            if (!head.syncHeadRotations()) continue;
            xHeadsRot[head.getIndex()] = (byte)Mth.m_14143_((float)(head.getHeadXRot() * 256.0f / 360.0f));
            yHeadsRot[head.getIndex()] = (byte)Mth.m_14143_((float)(head.getHeadYRot() * 256.0f / 360.0f));
        }
        return new PackedHeadRots(xHeadsRot, yHeadsRot);
    }

    public void updateHeadsFromPacked(PackedHeadRots rots) {
        for (int i = 0; i < this.heads.size(); ++i) {
            WitherStormHead head = (WitherStormHead)this.heads.get(i);
            if (!head.syncHeadRotations()) continue;
            float xRot = PackedHeadRots.unpack(rots.xRots[i]);
            float yRot = PackedHeadRots.unpack(rots.yRots[i]);
            head.setHeadXRot(xRot);
            head.setHeadYRot(yRot);
        }
    }

    public boolean areOtherHeadsDisabled() {
        return (Boolean)this.storm.m_20088_().m_135370_(OTHER_HEADS_DISABLED);
    }

    public void setOtherHeadsDisabled(boolean value) {
        this.storm.m_20088_().m_135381_(OTHER_HEADS_DISABLED, (Object)value);
        this.storm.getSegmentsManager().ifPresent(manager -> {
            WitherStormSegmentEntity[] segments = manager.getSegments();
            for (int i = 0; i < segments.length; ++i) {
                if (segments[i] == null) continue;
                segments[i].setOtherHeadsDisabled(value);
            }
        });
    }

    public void setHeadInjuryTime(int time) {
        this.storm.m_20088_().m_135381_(INJURY_TIME, (Object)time);
    }

    public int getHeadInjuryTime() {
        return (Integer)this.storm.m_20088_().m_135370_(INJURY_TIME);
    }

    public static void bootstrap() {
    }

    public record PackedHeadRots(byte[] xRots, byte[] yRots) {
        public void toPacket(FriendlyByteBuf buffer) {
            buffer.m_130087_(this.xRots);
            buffer.m_130087_(this.yRots);
        }

        public static PackedHeadRots fromPacket(FriendlyByteBuf buffer) {
            byte[] xRots = buffer.m_130052_();
            byte[] yRots = buffer.m_130052_();
            return new PackedHeadRots(xRots, yRots);
        }

        public static float unpack(byte b) {
            return (float)(b * 360) / 256.0f;
        }
    }
}

