/*
 * Decompiled with CFR 0.152.
 */
package nonamecrackers2.witherstormmod.common.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import nonamecrackers2.crackerslib.common.packet.Packet;
import nonamecrackers2.witherstormmod.client.packet.WitherStormModMessageHandlerClient;

public class GlobalSoundMessage
extends Packet {
    private SoundEvent event;
    private float pitch;
    private float volume;

    public GlobalSoundMessage(SoundEvent event, float volume, float pitch) {
        super(true);
        this.event = event;
        this.pitch = pitch;
        this.volume = volume;
    }

    public GlobalSoundMessage() {
        super(false);
    }

    public SoundEvent getSoundEvent() {
        return this.event;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.event).toString());
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.volume);
    }

    public void decode(FriendlyByteBuf buffer) {
        this.event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(buffer.m_130277_()));
        this.pitch = buffer.readFloat();
        this.volume = buffer.readFloat();
    }

    public Runnable getProcessor(NetworkEvent.Context context) {
        return () -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> WitherStormModMessageHandlerClient.processGlobalSoundMessage(this));
    }

    public String toString() {
        return "GlobalSoundMessage[sound_event=" + ForgeRegistries.SOUND_EVENTS.getKey((Object)this.event).toString() + ", pitch=" + String.valueOf(this.pitch) + ", volume=" + String.valueOf(this.volume) + "]";
    }
}

