/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.client.gui;

import com.talhanation.workers.Main;
import com.talhanation.workers.Translatable;
import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.LumberjackEntity;
import com.talhanation.workers.entities.MinerEntity;
import com.talhanation.workers.inventory.WorkerInventoryContainer;
import com.talhanation.workers.network.MessageLumberjackReplant;
import de.maxhenkel.workers.corelib.inventory.ScreenBase;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class WorkerInventoryScreen
extends ScreenBase<WorkerInventoryContainer> {
    private static final ResourceLocation GUI_TEXTURE_3 = new ResourceLocation("workers", "textures/gui/worker_gui.png");
    protected static final int fontColor = 0x404040;
    private final AbstractWorkerEntity worker;
    private final Inventory playerInventory;
    private boolean replantSaplings;

    public WorkerInventoryScreen(WorkerInventoryContainer container, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE_3, container, playerInventory, (Component)Component.m_237113_((String)""));
        Main.LOGGER.info("WorkerInventoryScreen loaded");
        this.worker = container.getWorker();
        this.playerInventory = playerInventory;
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        AbstractWorkerEntity abstractWorkerEntity = this.worker;
        if (abstractWorkerEntity instanceof LumberjackEntity) {
            LumberjackEntity lumberjack = (LumberjackEntity)abstractWorkerEntity;
            this.replantSaplings = lumberjack.getReplantSaplings();
        }
        this.setButtons();
    }

    private void setButtons() {
        this.m_169413_();
        if (this.worker instanceof LumberjackEntity) {
            String string = this.replantSaplings ? "True" : "False";
            this.setReplantSaplingsButton(string);
        }
    }

    private void setReplantSaplingsButton(String string) {
        ExtendedButton button = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 190, this.f_97736_ + 57, 40, 20, (Component)Component.m_237113_((String)string), button1 -> {
            this.replantSaplings = !this.replantSaplings;
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageLumberjackReplant(this.worker.m_20148_(), this.replantSaplings));
            this.setButtons();
        }));
        button.m_257544_(Tooltip.m_257550_((Component)Translatable.TOOLTIP_LUMBER_REPLANT));
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int offset;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        guiGraphics.m_280649_(this.f_96547_, this.worker.m_5446_().m_7532_(), 8, 6, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInventory.m_5446_().m_7532_(), 8, this.f_97727_ - 152 + 3, 0x404040, false);
        int n = offset = this.worker instanceof MinerEntity ? 10 : 0;
        if (this.worker.inventoryInputHelp() != null) {
            for (int i = 0; i < this.worker.inventoryInputHelp().size(); ++i) {
                this.renderItemAt(guiGraphics, this.worker.inventoryInputHelp().get(i).m_7968_(), 60 - offset + 15 * i, this.f_97727_ - 165);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
    }

    private void renderItemAt(GuiGraphics guiGraphics, ItemStack itemStack, int x, int y) {
        if (itemStack != null) {
            guiGraphics.m_280203_(itemStack, x, y);
        }
    }
}

