/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.entities.ai;

import com.talhanation.workers.entities.AbstractWorkerEntity;
import com.talhanation.workers.entities.IBoatController;
import com.talhanation.workers.entities.ai.navigation.SailorPathNavigation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class ControlBoatAI
extends Goal {
    private final AbstractWorkerEntity worker;
    private State state;
    private Path path;
    private Node node;
    private int timer;
    private float precision;
    private final boolean DEBUG = false;

    public ControlBoatAI(IBoatController sailor) {
        this.worker = sailor.getWorker();
    }

    public boolean m_8036_() {
        Boat boat;
        Entity entity = this.worker.m_20202_();
        return entity instanceof Boat && ((Entity)(boat = (Boat)entity).m_20197_().get(0)).equals((Object)this.worker);
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        this.state = State.IDLE;
        this.precision = 100.0f;
    }

    public void m_8041_() {
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        AbstractWorkerEntity abstractWorkerEntity = this.worker;
        if (abstractWorkerEntity instanceof IBoatController) {
            IBoatController sailor = (IBoatController)((Object)abstractWorkerEntity);
            if (!this.worker.m_20193_().m_5776_() && (abstractWorkerEntity = this.worker.m_21573_()) instanceof SailorPathNavigation) {
                SailorPathNavigation sailorPathNavigation = (SailorPathNavigation)((Object)abstractWorkerEntity);
                switch (this.state) {
                    case IDLE: {
                        if (sailor.getSailPos() == null) break;
                        this.state = State.CREATING_PATH;
                        break;
                    }
                    case CREATING_PATH: {
                        if (sailor.getSailPos() != null) {
                            this.path = sailorPathNavigation.createPath(sailor.getSailPos(), 16, false, 0);
                            if (this.path == null) break;
                            this.node = this.path.m_77401_();
                            this.state = State.MOVING_PATH;
                            break;
                        }
                        this.state = State.IDLE;
                        break;
                    }
                    case MOVING_PATH: {
                        double distance;
                        if (!this.worker.m_20202_().f_19862_ && this.getWaterDepth(this.worker.m_20097_()) >= 7 && this.path.m_77395_() != null) {
                            this.node = this.path.m_77395_();
                        }
                        if ((distance = this.worker.m_20275_(this.node.f_77271_, this.node.f_77272_, this.node.f_77273_)) >= 5.0) {
                            sailor.updateBoatControl(this.node.f_77271_, this.node.f_77273_, 0.9f, 1.1f, this.node);
                        }
                        if (distance <= (double)this.precision) {
                            this.path.m_77374_();
                            this.precision = !this.isFreeWater(this.node) ? sailor.getPrecisionMin() : sailor.getPrecisionMax();
                            this.timer = 0;
                            if (this.path.m_77398_() == this.path.m_77399_() - 1) {
                                this.state = State.CREATING_PATH;
                            }
                            if (this.path.m_77398_() == this.path.m_77399_() - 1 || this.node.equals((Object)this.path.m_77395_())) {
                                this.node = null;
                                this.state = State.DONE;
                            }
                            try {
                                this.node = this.path.m_77401_();
                            }
                            catch (IndexOutOfBoundsException e) {
                                this.node = (Node)this.path.f_77362_.get(this.path.f_77362_.size() - 1);
                            }
                            break;
                        }
                        if (++this.timer <= 50) break;
                        if (this.precision < 300.0f) {
                            this.precision += 25.0f;
                        } else {
                            this.precision = 50.0f;
                            this.state = State.CREATING_PATH;
                        }
                        this.timer = 0;
                        break;
                    }
                    case DONE: {
                        sailor.setSailPos(null);
                        this.state = State.IDLE;
                    }
                }
            }
        }
    }

    private int getWaterDepth(BlockPos pos) {
        BlockState state;
        int depth = 0;
        for (int i = 0; i < 10 && (state = this.worker.m_20193_().m_8055_(pos.m_6625_(i))).m_60713_(Blocks.f_49990_); ++i) {
            ++depth;
        }
        return depth;
    }

    private boolean isFreeWater(Node node) {
        for (int i = -2; i <= 2; ++i) {
            for (int k = -2; k <= 2; ++k) {
                BlockPos pos = new BlockPos(node.f_77271_, (int)this.worker.m_20186_(), node.f_77273_).m_7918_(i, 0, k);
                BlockState state = this.worker.m_20193_().m_8055_(pos);
                if (state.m_60713_(Blocks.f_49990_) && state.m_60713_(Blocks.f_50576_) && state.m_60713_(Blocks.f_50575_)) continue;
                return false;
            }
        }
        return true;
    }

    static enum State {
        IDLE,
        CREATING_PATH,
        MOVING_PATH,
        DONE;

    }
}

