/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.Main;
import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.network.MessageToClientUpdateMerchantScreen;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageMerchantAddWayPoint
implements Message<MessageMerchantAddWayPoint> {
    private UUID worker;

    public MessageMerchantAddWayPoint() {
    }

    public MessageMerchantAddWayPoint(UUID recruit) {
        this.worker = recruit;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        player.m_20193_().m_6443_(MerchantEntity.class, player.m_20191_().m_82400_(100.0), v -> v.m_20148_().equals(this.worker)).stream().filter(LivingEntity::m_6084_).findAny().ifPresent(merchant -> this.addWayPoint(player, (MerchantEntity)merchant));
    }

    private void addWayPoint(ServerPlayer player, MerchantEntity merchant) {
        BlockPos pos = merchant.m_20069_() ? merchant.m_20097_().m_7494_() : merchant.m_20097_();
        BlockState state = merchant.m_20193_().m_8055_(pos);
        if (state.m_60795_()) {
            pos = pos.m_7495_();
        }
        merchant.setStartPos(pos);
        Main.SIMPLE_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageToClientUpdateMerchantScreen(merchant.WAYPOINTS, merchant.WAYPOINT_ITEMS, merchant.getCurrentTrades(), merchant.getTradeLimits(), merchant.getTraveling(), merchant.getReturning()));
    }

    @Override
    public MessageMerchantAddWayPoint fromBytes(FriendlyByteBuf buf) {
        this.worker = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.worker);
    }
}

