/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.workers.network;

import com.talhanation.workers.entities.MerchantEntity;
import com.talhanation.workers.init.ModItems;
import de.maxhenkel.workers.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageWriteSpawnEgg
implements Message<MessageWriteSpawnEgg> {
    private UUID merchant;

    public MessageWriteSpawnEgg() {
    }

    public MessageWriteSpawnEgg(UUID merchant) {
        this.merchant = merchant;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        List merchantlist = Objects.requireNonNull(context.getSender()).m_20193_().m_45976_(MerchantEntity.class, context.getSender().m_20191_().m_82400_(64.0));
        for (MerchantEntity merchant : merchantlist) {
            CompoundTag compoundnbt;
            if (!merchant.m_20148_().equals(this.merchant)) continue;
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.MERCHANT_SPAWN_EGG.get());
            CompoundTag entityTag = new CompoundTag();
            String name = merchant.m_7755_().getString();
            Team team = merchant.m_5647_();
            if (team != null) {
                entityTag.m_128359_("Team", team.m_5758_());
            }
            entityTag.m_128359_("Name", name);
            ListTag list = new ListTag();
            for (int i = 0; i < merchant.getTradeInventory().m_6643_(); ++i) {
                ItemStack itemstack = merchant.getTradeInventory().m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundnbt2 = new CompoundTag();
                compoundnbt2.m_128344_("TradeSlot", (byte)i);
                itemstack.m_41739_(compoundnbt2);
                list.add((Object)compoundnbt2);
            }
            entityTag.m_128365_("TradeInventory", (Tag)list);
            if (merchant.getHorseUUID() != null) {
                entityTag.m_128362_("HorseUUID", merchant.getHorseUUID());
            }
            if (merchant.getBoatUUID() != null) {
                entityTag.m_128362_("BoatUUID", merchant.getBoatUUID());
            }
            entityTag.m_128379_("Traveling", merchant.getTraveling());
            entityTag.m_128379_("AutoStartTravel", merchant.getAutoStartTravel());
            entityTag.m_128379_("Returning", merchant.getReturning());
            entityTag.m_128405_("CurrentWayPointIndex", merchant.getCurrentWayPointIndex());
            entityTag.m_128405_("ReturningTime", merchant.getReturningTime());
            entityTag.m_128405_("CurrentReturningTime", merchant.getCurrentReturningTime());
            entityTag.m_128379_("isCreative", merchant.isCreative());
            entityTag.m_128379_("isDayCounted", merchant.isDayCounted());
            BlockPos currentWayPoint = merchant.getCurrentWayPoint();
            if (currentWayPoint != null) {
                merchant.setNbtPosition(entityTag, "CurrentWayPoint", currentWayPoint);
            }
            ListTag waypointItems = new ListTag();
            for (int i = 0; i < merchant.WAYPOINT_ITEMS.size(); ++i) {
                ItemStack itemstack = merchant.WAYPOINT_ITEMS.get(i);
                if (itemstack.m_41619_()) continue;
                compoundnbt = new CompoundTag();
                compoundnbt.m_128344_("WaypointItem", (byte)i);
                itemstack.m_41739_(compoundnbt);
                waypointItems.add((Object)compoundnbt);
            }
            entityTag.m_128365_("WaypointItems", (Tag)waypointItems);
            ListTag waypoints = new ListTag();
            for (int i = 0; i < merchant.WAYPOINTS.size(); ++i) {
                compoundnbt = new CompoundTag();
                compoundnbt.m_128344_("Waypoint", (byte)i);
                BlockPos pos = merchant.WAYPOINTS.get(i);
                compoundnbt.m_128347_("PosX", (double)pos.m_123341_());
                compoundnbt.m_128347_("PosY", (double)pos.m_123342_());
                compoundnbt.m_128347_("PosZ", (double)pos.m_123343_());
                waypoints.add((Object)compoundnbt);
            }
            entityTag.m_128365_("Waypoints", (Tag)waypoints);
            ListTag limits = new ListTag();
            for (int i = 0; i < 4; ++i) {
                CompoundTag compoundnbt3 = new CompoundTag();
                compoundnbt3.m_128344_("TradeLimit_" + i, (byte)i);
                int limit = merchant.getTradeLimits().get(i);
                compoundnbt3.m_128405_("Limit", limit);
                limits.add((Object)compoundnbt3);
            }
            entityTag.m_128365_("TradeLimits", (Tag)limits);
            ListTag trades = new ListTag();
            for (int i = 0; i < 4; ++i) {
                CompoundTag compoundnbt4 = new CompoundTag();
                compoundnbt4.m_128344_("Trade_" + i, (byte)i);
                int trade = merchant.getCurrentTrades().get(i);
                compoundnbt4.m_128405_("Trade", trade);
                trades.add((Object)compoundnbt4);
            }
            entityTag.m_128365_("Trades", (Tag)trades);
            entityTag.m_128405_("State", merchant.getState());
            entityTag.m_128405_("TravelSpeedState", merchant.getTravelSpeedState());
            entityTag.m_128379_("InfoTravel", merchant.getSendInfo());
            ListTag listnbt = new ListTag();
            for (int i = 0; i < merchant.getInventory().m_6643_(); ++i) {
                ItemStack itemstack = merchant.getInventory().m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundnbt5 = new CompoundTag();
                compoundnbt5.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundnbt5);
                listnbt.add((Object)compoundnbt5);
            }
            entityTag.m_128365_("Items", (Tag)listnbt);
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128365_("EntityTag", (Tag)entityTag);
            if (itemStack == null || serverPlayer == null || !serverPlayer.m_21205_().m_41619_()) break;
            itemStack.m_41751_(itemTag);
            serverPlayer.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            break;
        }
    }

    @Override
    public MessageWriteSpawnEgg fromBytes(FriendlyByteBuf buf) {
        this.merchant = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.merchant);
    }
}

