/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.ftbteams;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.client.ClientTeamManager;
import dev.ftb.mods.ftbteams.api.client.KnownClientPlayer;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.TeamHandler;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class FTBTeamsCompat
implements TeamHandler {
    @Override
    public boolean areOnSameTeam(Owner owner1, Owner owner2) {
        try {
            ClientTeamManager manager;
            Optional optional1;
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            if (api.isManagerLoaded()) {
                return api.getManager().arePlayersInSameTeam(UUID.fromString(owner1.getUUID()), UUID.fromString(owner2.getUUID()));
            }
            if (api.isClientManagerLoaded() && (optional1 = (manager = api.getClientManager()).getKnownPlayer(UUID.fromString(owner1.getUUID()))).isPresent()) {
                Optional optional2 = manager.getKnownPlayer(UUID.fromString(owner2.getUUID()));
                return optional2.isPresent() && ((KnownClientPlayer)optional1.get()).teamId().equals(((KnownClientPlayer)optional2.get()).teamId());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public TeamUtils.TeamRepresentation getTeamRepresentation(Owner owner) {
        try {
            Optional optionalTeam;
            ClientTeamManager manager;
            Optional optionalPlayer;
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            Team team = null;
            if (api.isManagerLoaded()) {
                Optional optional = api.getManager().getTeamForPlayerID(UUID.fromString(owner.getUUID()));
                if (optional.isPresent()) {
                    team = (Team)optional.get();
                }
            } else if (api.isClientManagerLoaded() && (optionalPlayer = (manager = api.getClientManager()).getKnownPlayer(UUID.fromString(owner.getUUID()))).isPresent() && (optionalTeam = manager.getTeamByID(((KnownClientPlayer)optionalPlayer.get()).teamId())).isPresent()) {
                team = (Team)optionalTeam.get();
            }
            if (team != null && team.getMembers().size() > 1) {
                return new TeamUtils.TeamRepresentation((String)team.getProperty((TeamProperty)TeamProperties.DISPLAY_NAME), ((Color4I)team.getProperty((TeamProperty)TeamProperties.COLOR)).toStyle().m_131135_().m_131265_());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Collection<ServerPlayer> getOnlinePlayersFromOwner(MinecraftServer server, Owner owner) {
        try {
            Optional optional;
            FTBTeamsAPI.API api = FTBTeamsAPI.api();
            if (api.isManagerLoaded() && (optional = api.getManager().getTeamForPlayerID(UUID.fromString(owner.getUUID()))).isPresent()) {
                return ((Team)optional.get()).getOnlineMembers();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new ArrayList<ServerPlayer>();
    }
}

