/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class OverlayToggleHandler {
    private static final List<IGuiOverlay> DISABLED_OVERLAYS = new ArrayList<IGuiOverlay>();

    private OverlayToggleHandler() {
    }

    @SubscribeEvent
    public static void onRenderGuiOverlayPre(RenderGuiOverlayEvent.Pre event) {
        if (OverlayToggleHandler.isDisabled(event.getOverlay())) {
            event.setCanceled(true);
        }
    }

    public static boolean isDisabled(VanillaGuiOverlay overlay) {
        NamedGuiOverlay namedGuiOverlay = GuiOverlayManager.findOverlay((ResourceLocation)overlay.id());
        if (namedGuiOverlay != null) {
            return OverlayToggleHandler.isDisabled(namedGuiOverlay.overlay());
        }
        return true;
    }

    public static boolean isDisabled(NamedGuiOverlay overlay) {
        return OverlayToggleHandler.isDisabled(overlay.overlay());
    }

    public static boolean isDisabled(IGuiOverlay overlay) {
        return DISABLED_OVERLAYS.contains(overlay);
    }

    public static void enable(VanillaGuiOverlay overlay) {
        OverlayToggleHandler.enable(overlay.type().overlay());
    }

    public static void enable(NamedGuiOverlay overlay) {
        OverlayToggleHandler.enable(overlay.overlay());
    }

    public static void enable(IGuiOverlay overlay) {
        DISABLED_OVERLAYS.remove(overlay);
    }

    public static void disable(VanillaGuiOverlay overlay) {
        OverlayToggleHandler.disable(overlay.type().overlay());
    }

    public static void disable(NamedGuiOverlay overlay) {
        OverlayToggleHandler.disable(overlay.overlay());
    }

    public static void disable(IGuiOverlay overlay) {
        if (!OverlayToggleHandler.isDisabled(overlay)) {
            DISABLED_OVERLAYS.add(overlay);
        }
    }
}

