/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TogglePictureButton
extends Button
implements IToggleableButton {
    private ResourceLocation textureLocation;
    private int[] u;
    private int[] v;
    private int currentIndex = 0;
    private final int toggleCount;
    private final int drawOffset;
    private final int drawWidth;
    private final int drawHeight;
    private final int uWidth;
    private final int vHeight;
    private final int textureWidth;
    private final int textureHeight;

    public TogglePictureButton(int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int toggleCount, Button.OnPress onPress) {
        this(xPos, yPos, width, height, texture, textureX, textureY, drawOffset, 16, 16, 16, 16, 256, 256, toggleCount, onPress);
    }

    public TogglePictureButton(int xPos, int yPos, int width, int height, ResourceLocation texture, int[] textureX, int[] textureY, int drawOffset, int drawWidth, int drawHeight, int uWidth, int vHeight, int textureWidth, int textureHeight, int toggleCount, Button.OnPress onPress) {
        super(xPos, yPos, width, height, (Component)Component.m_237119_(), onPress, f_252438_);
        if (textureX.length != toggleCount || textureY.length != toggleCount) {
            throw new IllegalArgumentException("TogglePictureButton was set up incorrectly. Array lengths must match toggleCount!");
        }
        this.textureLocation = texture;
        this.u = textureX;
        this.v = textureY;
        this.toggleCount = toggleCount;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.drawOffset = drawOffset;
        this.drawWidth = drawWidth;
        this.drawHeight = drawHeight;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
            guiGraphics.blitWithBorder(f_93617_, this.m_252754_(), this.m_252907_(), 0, 46 + (!this.f_93623_ ? 0 : (this.m_198029_() ? 40 : 20)), this.f_93618_, this.f_93619_, 200, 20, 2, 3, 2, 2);
            if (this.getTextureLocation() != null) {
                guiGraphics.m_280411_(this.getTextureLocation(), this.m_252754_() + this.drawOffset, this.m_252907_() + this.drawOffset, this.drawWidth, this.drawHeight, (float)this.u[this.currentIndex], (float)this.v[this.currentIndex], this.uWidth, this.vHeight, this.textureWidth, this.textureHeight);
            }
        }
    }

    public void m_5691_() {
        if (Screen.m_96638_()) {
            this.setCurrentIndex(this.currentIndex - 1);
        } else {
            this.setCurrentIndex(this.currentIndex + 1);
        }
        super.m_5691_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.setCurrentIndex(this.currentIndex - (int)Math.signum(delta));
        this.f_93717_.m_93750_((Button)this);
        return true;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int newIndex) {
        this.currentIndex = Math.floorMod(newIndex, this.toggleCount);
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }
}

