/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adhooks.motion.AbstractMotionController;
import com.endertech.minecraft.mods.adhooks.motion.ClientMotionController;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.ServerMotionController;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;

public class MotionControllers {
    private static final Map<Dist, AbstractMotionController> controllers = new EnumMap<Dist, AbstractMotionController>(Dist.class);

    public static Optional<EntityTarget<?>> getTarget(Entity entity) {
        if (ForgeEntity.isClientSide((Entity)entity)) {
            return MotionControllers.getController(Dist.CLIENT).getTarget(entity);
        }
        return MotionControllers.getController(Dist.DEDICATED_SERVER).getTarget(entity);
    }

    public static AbstractMotionController getController(Dist dist) {
        return switch (dist) {
            default -> throw new IncompatibleClassChangeError();
            case Dist.DEDICATED_SERVER -> controllers.computeIfAbsent(Dist.DEDICATED_SERVER, key -> new ServerMotionController());
            case Dist.CLIENT -> controllers.computeIfAbsent(Dist.CLIENT, key -> new ClientMotionController());
        };
    }

    public static float getMainFactor() {
        return 1.3333334f;
    }

    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MotionControllers.getController(Dist.DEDICATED_SERVER).applyMotions();
        }
    }

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MotionControllers.getController(Dist.CLIENT).applyMotions();
        }
    }
}

