/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.parts;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Combustion;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.motion.ClientPlayerTarget;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.MotionControllers;
import com.endertech.minecraft.mods.adhooks.network.JumpBoostMsg;
import com.endertech.minecraft.mods.adhooks.network.TarzanJumpMsg;
import com.endertech.minecraft.mods.adhooks.parts.Hook;
import com.endertech.minecraft.mods.adhooks.parts.Launcher;
import com.endertech.minecraft.mods.adhooks.parts.Rope;
import com.endertech.minecraft.mods.adhooks.properties.HookType;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.CameraType;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HookShot
extends ForgeEntity {
    public static final float GRAVITY_VELOCITY = 0.005f;
    public static final int RENDER_DISTANCE = 255;
    protected Direction hitSide = null;
    protected LivingEntity shooter = null;
    protected static final Map<SynchedBools, EntityDataAccessor<Boolean>> boolDataKeys = HookShot.createDataKeysMap(SynchedBools.class, EntityDataSerializers.f_135035_);
    protected static final Map<SynchedInts, EntityDataAccessor<Integer>> intDataKeys = HookShot.createDataKeysMap(SynchedInts.class, EntityDataSerializers.f_135028_);
    protected static final Map<SynchedFloats, EntityDataAccessor<Float>> floatDataKeys = HookShot.createDataKeysMap(SynchedFloats.class, EntityDataSerializers.f_135029_);
    protected final Combustion combustion = new Combustion();

    protected static <E extends Enum<E>, D> Map<E, EntityDataAccessor<D>> createDataKeysMap(Class<E> clazz, EntityDataSerializer<D> serializer) {
        return (Map)Stream.of((Enum[])clazz.getEnumConstants()).map(b -> Map.entry(b, SynchedEntityData.m_135353_(HookShot.class, (EntityDataSerializer)serializer))).collect(Maps.toImmutableEnumMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public HookShot(EntityType<HookShot> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public HookShot(Level level, LivingEntity shooter, HookType hookType) {
        this((EntityType<HookShot>)((EntityType)AdHooks.getInstance().entities.hookShot.get()), level);
        this.shooter = shooter;
        this.setSynchedData(SynchedInts.SHOOTER_ID, shooter.m_19879_());
        this.setSynchedData(SynchedInts.HOOK_TYPE, hookType.ordinal());
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_(), shooter.m_20189_(), shooter.m_146908_(), shooter.m_146909_());
    }

    protected void developMsg(String valueName, Object value) {
        ForgeEndertech.developMsg((String)((this.isClientSide() ? "CLIENT" : "SERVER") + ": " + valueName + " = " + value.toString()));
    }

    protected void m_8097_() {
        boolDataKeys.values().forEach(key -> this.f_19804_.m_135372_(key, (Object)false));
        intDataKeys.values().forEach(key -> this.f_19804_.m_135372_(key, (Object)0));
        floatDataKeys.values().forEach(key -> this.f_19804_.m_135372_(key, (Object)Float.valueOf(0.0f)));
    }

    public boolean getSynchedData(SynchedBools key) {
        return (Boolean)this.m_20088_().m_135370_(boolDataKeys.get((Object)key));
    }

    public void setSynchedData(SynchedBools key, boolean value) {
        this.m_20088_().m_135381_(boolDataKeys.get((Object)key), (Object)value);
    }

    public int getSynchedData(SynchedInts key) {
        return (Integer)this.m_20088_().m_135370_(intDataKeys.get((Object)key));
    }

    public void setSynchedData(SynchedInts key, int value) {
        this.m_20088_().m_135381_(intDataKeys.get((Object)key), (Object)value);
    }

    public float getSynchedData(SynchedFloats key) {
        return ((Float)this.m_20088_().m_135370_(floatDataKeys.get((Object)key))).floatValue();
    }

    public void setSynchedData(SynchedFloats key, float value) {
        this.m_20088_().m_135381_(floatDataKeys.get((Object)key), (Object)Float.valueOf(value));
    }

    public boolean isLoosening() {
        return this.getSynchedData(SynchedBools.LOOSENING);
    }

    public boolean isPulling() {
        return this.getSynchedData(SynchedBools.PULLING);
    }

    public State getPrevState() {
        int i = this.getSynchedData(SynchedInts.PREV_STATE);
        return State.values()[i];
    }

    public State getState() {
        int i = this.getSynchedData(SynchedInts.STATE);
        return State.values()[i];
    }

    public void setState(State state) {
        State prevState;
        if (this.isServerSide() && state != (prevState = this.getState())) {
            this.setSynchedData(SynchedInts.PREV_STATE, prevState.ordinal());
            this.setSynchedData(SynchedInts.STATE, state.ordinal());
        }
    }

    public float getRopeLength() {
        return this.getSynchedData(SynchedFloats.ROPE_LENGTH);
    }

    public void setRopeLength(float ropeLength) {
        if (this.isServerSide()) {
            this.setSynchedData(SynchedFloats.ROPE_LENGTH, ropeLength);
        }
    }

    public float getSagging() {
        return this.getSynchedData(SynchedFloats.SAGGING);
    }

    public void setSagging(float sagging) {
        if (this.isServerSide()) {
            if (sagging < 0.0f) {
                sagging = 0.0f;
            }
            this.setSynchedData(SynchedFloats.SAGGING, sagging);
        }
    }

    public HookType getHookType() {
        int ordinal = this.getSynchedData(SynchedInts.HOOK_TYPE);
        return HookType.values()[ordinal];
    }

    public boolean canHookOnReeling() {
        return this.getHookType() == HookType.PUDGE;
    }

    public BlockAction getBlockAction(Level level, BlockPos pos) {
        if (GameWorld.isAirBlock((LevelReader)level, (BlockPos)pos)) {
            return BlockAction.PASS;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        HookType hookType = this.getHookType();
        Hook hook = hookType.hook;
        boolean whitelistIsEmpty = ((List)hook.hookableBlocks.getValue()).isEmpty();
        if (hook.breakableBlocks.test(state)) {
            return BlockAction.BREAK;
        }
        if (hook.hookableBlocks.test(state)) {
            return BlockAction.HOOK;
        }
        if (!whitelistIsEmpty || hook.reboundableBlocks.test(state)) {
            return BlockAction.BOUNCE;
        }
        switch (hookType) {
            case PUDGE: {
                boolean isPole;
                if (block instanceof TorchBlock || block instanceof LanternBlock || block instanceof BellBlock) {
                    return BlockAction.BREAK;
                }
                VoxelShape collisionShape = state.m_60812_((BlockGetter)level, pos);
                if (collisionShape.m_83281_()) {
                    return BlockAction.BREAK;
                }
                if (state.m_204336_(BlockTags.f_13035_)) {
                    return BlockAction.HOOK;
                }
                if (state.m_204336_(BlockTags.f_13039_) || state.m_204336_(BlockTags.f_13055_)) {
                    return BlockAction.HOOK;
                }
                if (block instanceof IronBarsBlock && state.m_60827_() == SoundType.f_56743_) {
                    return BlockAction.HOOK;
                }
                double width = 0.15;
                VoxelShape poleShape = Shapes.m_83048_((double)0.35, (double)0.0, (double)0.35, (double)0.65, (double)1.0, (double)0.65);
                boolean bl = isPole = !Shapes.m_83157_((VoxelShape)collisionShape, (VoxelShape)poleShape, (BooleanOp)BooleanOp.f_82685_);
                if (isPole) {
                    return BlockAction.HOOK;
                }
                if (state.m_60827_() == SoundType.f_56743_) {
                    return BlockAction.BOUNCE;
                }
                if (state.m_60827_() == SoundType.f_154663_) {
                    return BlockAction.BOUNCE;
                }
                BlockPos blockAbovePos = pos.m_7494_();
                boolean isShooterBelowHook = this.getShooter().map(Entity::m_20183_).map(shooterPos -> blockAbovePos.m_123342_() - shooterPos.m_123342_() > 4).orElse(false);
                if (isShooterBelowHook && level.m_8055_(blockAbovePos).m_60812_((BlockGetter)level, blockAbovePos).m_83281_()) {
                    return BlockAction.HOOK;
                }
                return BlockAction.BOUNCE;
            }
            case SPEAR: {
                if (state.m_60827_() == SoundType.f_56743_) {
                    return BlockAction.BOUNCE;
                }
                if (state.m_60827_() == SoundType.f_154663_) {
                    return BlockAction.BOUNCE;
                }
                return BlockAction.HOOK;
            }
            case WEB: {
                return BlockAction.HOOK;
            }
        }
        return BlockAction.HOOK;
    }

    protected Vect3d getHitPosition() {
        return Vect3d.from((double)this.getSynchedData(SynchedFloats.HIT_X), (double)this.getSynchedData(SynchedFloats.HIT_Y), (double)this.getSynchedData(SynchedFloats.HIT_Z));
    }

    public Vect3d getLauncherPosition() {
        return this.getShooter().map(ForgeEntity::getCenterPosition).orElse(Vect3d.ZERO);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vect3d getLauncherPosition(CameraType pov, float partialTicks) {
        double dx;
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter == null) {
            return Vect3d.ZERO;
        }
        InteractionHand hand = this.getLauncherHand().orElse(null);
        double d = dx = hand != null ? 0.2 : 0.0;
        if (hand == InteractionHand.MAIN_HAND) {
            dx = -dx;
        }
        Vect3d offset = Vect3d.from((double)dx, (double)0.0, (double)0.0);
        float yaw = shooter.f_20883_;
        if (shooter instanceof LocalPlayer && pov == CameraType.FIRST_PERSON) {
            offset = offset.move(0.0, 0.0, -0.6);
            yaw = shooter.m_5675_(partialTicks);
        }
        offset = offset.rotateAroundY(-yaw);
        return HookShot.getCenterPosition((Entity)shooter, (float)partialTicks).add(offset);
    }

    public void setHitPosition(Vect3d hitPosition) {
        if (this.isServerSide() && hitPosition != null) {
            this.setSynchedData(SynchedFloats.HIT_X, (float)hitPosition.x);
            this.setSynchedData(SynchedFloats.HIT_Y, (float)hitPosition.y);
            this.setSynchedData(SynchedFloats.HIT_Z, (float)hitPosition.z);
        }
    }

    public boolean isHookingBlock() {
        return this.getState() == State.HOOKING_BLOCK;
    }

    public boolean isHookingEntity() {
        return this.getState() == State.HOOKING_ENTITY;
    }

    public Optional<InteractionHand> getLauncherHand() {
        int value = this.getSynchedData(SynchedInts.LAUNCHER_HAND);
        return value >= 0 ? Optional.of(InteractionHand.values()[value]) : Optional.empty();
    }

    protected void updateLauncherHand() {
        if (!this.isServerSide()) {
            return;
        }
        int value = -1;
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter != null) {
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack itemStack = shooter.m_21120_(hand);
                if (!Launcher.isAttachedToHookShot(itemStack, this)) continue;
                value = hand.ordinal();
                break;
            }
        }
        this.setSynchedData(SynchedInts.LAUNCHER_HAND, value);
    }

    public BlockPos getHookedBlockPos() {
        return new BlockPos(this.getSynchedData(SynchedInts.HOOKED_BLOCK_X), this.getSynchedData(SynchedInts.HOOKED_BLOCK_Y), this.getSynchedData(SynchedInts.HOOKED_BLOCK_Z));
    }

    protected void setHookedBlockPos(BlockHitResult hit) {
        if (this.isServerSide()) {
            BlockPos pos = hit.m_82425_();
            this.setSynchedData(SynchedInts.HOOKED_BLOCK_X, pos.m_123341_());
            this.setSynchedData(SynchedInts.HOOKED_BLOCK_Y, pos.m_123342_());
            this.setSynchedData(SynchedInts.HOOKED_BLOCK_Z, pos.m_123343_());
        }
    }

    protected void onTargetHit(HitResult hit) {
        if (hit == null) {
            return;
        }
        if (this.getState() == State.REELING && !this.canHookOnReeling()) {
            return;
        }
        Vect3d hitPosition = Vect3d.from((Vec3)hit.m_82450_());
        if (hit instanceof BlockHitResult) {
            BlockHitResult trace = (BlockHitResult)hit;
            BlockPos pos = trace.m_82425_();
            BlockAction action = this.getBlockAction(this.m_9236_(), pos);
            switch (action) {
                case HOOK: {
                    break;
                }
                case BREAK: {
                    if (this.isServerSide()) {
                        BlockState state = this.m_9236_().m_8055_(pos);
                        this.m_9236_().m_46961_(pos, state.m_60827_() != SoundType.f_56744_);
                    }
                }
                case BOUNCE: {
                    this.setState(State.REELING);
                    if (this.isServerSide()) {
                        SoundEvent sound = this.m_9236_().m_8055_(pos).m_60827_().m_56778_();
                        this.m_5496_(sound, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
                    }
                }
                default: {
                    return;
                }
            }
            this.hitSide = trace.m_82434_();
            Vect3d offsetVec = Vect3d.from((Vec3i)this.hitSide.m_122436_()).scale(0.05);
            hitPosition = hitPosition.add(offsetVec);
            this.setHookedBlockPos(trace);
            this.setHitPosition(hitPosition);
            this.setState(State.HOOKING_BLOCK);
        } else if (hit instanceof EntityHitResult) {
            Entity target = ((EntityHitResult)hit).m_82443_();
            if (target instanceof EnderDragonPart) {
                target = ((EnderDragonPart)target).f_31010_;
            }
            if (!this.canBeAttachedTo(target)) {
                return;
            }
            float damage = this.getHookType().hook.getDamage();
            if (damage > 0.0f && this.getShooter().isPresent()) {
                target.m_6469_(this.m_269291_().m_269299_((Entity)this, this.getShooter().get()), damage);
            }
            this.setSynchedData(SynchedInts.HOOKED_ENTITY_ID, target.m_19879_());
            this.setState(State.HOOKING_ENTITY);
        } else {
            return;
        }
        float ropeLength = (float)(this.getLauncherPosition().distance(hitPosition) + (double)this.getHookType().launcher.getReelingSpeed());
        this.setRopeLength(ropeLength);
        this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    protected boolean canBeAttachedTo(Entity entity) {
        HookType type = this.getHookType();
        Hook hook = type.hook;
        if (entity == null || hook == null || !this.getShooter().isPresent()) {
            return false;
        }
        if (entity instanceof Player) {
            return hook.affectsPlayers();
        }
        if (entity instanceof ItemEntity) {
            return hook.affectsItems();
        }
        return hook.affectsNPCs();
    }

    public double m_20204_() {
        return super.m_20204_();
    }

    protected void updatePhysics() {
        ServerPlayer player;
        Entity hookedEntity;
        HookType hookType = this.getHookType();
        State state = this.getState();
        LivingEntity shooter = this.getShooter().orElse(null);
        Entity entity = hookedEntity = state == State.HOOKING_ENTITY ? (Entity)this.findHookedEntity().orElse(null) : null;
        if (shooter == null || !shooter.m_6084_()) {
            this.m_146870_();
            return;
        }
        if (shooter instanceof ServerPlayer && Launcher.findAttachedLauncher((player = (ServerPlayer)shooter).m_150109_(), this).isEmpty()) {
            this.m_146870_();
            return;
        }
        Vect3d launcherPosition = this.getLauncherPosition();
        Vect3d tensionVec = Vect3d.ZERO;
        float tensionForce = 0.0f;
        float hookDistance = this.getHookDistance();
        Vect3d hookPosition = this.getCurPosition();
        FloatBounds ropeLengthBounds = hookType.rope.getLengthBounds(shooter, hookedEntity);
        float ropeLength = ropeLengthBounds.enclose(Float.valueOf(this.getRopeLength())).floatValue();
        float reelingSpeed = hookType.launcher.getReelingSpeed();
        switch (state) {
            case SHOOTING: {
                ropeLength = hookDistance + reelingSpeed;
                if (!(ropeLength > ropeLengthBounds.getMax().floatValue())) break;
                this.setState(State.REELING);
                return;
            }
            case REELING: {
                float reelingSpeedMult = 4.0f;
                if (this.isPulling()) {
                    reelingSpeedMult *= 2.0f;
                }
                Vect3d motionVec = launcherPosition.subtract(hookPosition).resize((double)(reelingSpeed * reelingSpeedMult));
                this.setMotion(motionVec);
                float hookNextDistance = (float)launcherPosition.distance(this.getNextPosition());
                ropeLength = hookDistance;
                if (!(ropeLength <= ropeLengthBounds.getMin().floatValue()) && !(hookDistance <= hookNextDistance)) break;
                this.m_146870_();
                return;
            }
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (!(ropeLength < hookDistance)) break;
                tensionForce = hookType.rope.getTensionForce(ropeLength, hookDistance);
                tensionVec = hookPosition.subtract(launcherPosition).resize((double)tensionForce);
                float hookStrength = hookType.hook.getStrength();
                if (tensionForce > hookStrength) {
                    this.setState(State.REELING);
                    return;
                }
                HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
                break;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: {
                if (hookType == HookType.PUDGE && ropeLength <= ropeLengthBounds.getMin().floatValue()) {
                    if (this.getSynchedData(SynchedBools.JUMPING)) {
                        this.doJumpBoost();
                    }
                    this.m_146870_();
                    return;
                }
                this.addMotionTo((Entity)shooter, tensionVec);
                break;
            }
            case HOOKING_ENTITY: {
                float targetWeight;
                if (hookedEntity == null) {
                    this.setState(State.REELING);
                    return;
                }
                if (ropeLength <= hookDistance || tensionVec.notZero()) {
                    HookShot.setFallDistance((Entity)hookedEntity, (float)0.0f, (boolean)true);
                }
                if (hookType == HookType.PUDGE && ropeLength <= ropeLengthBounds.getMin().floatValue()) {
                    hookedEntity.m_6034_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
                    this.m_146870_();
                    return;
                }
                float shooterWeight = HookShot.getWeight((Entity)shooter, (boolean)false) * hookType.launcher.getShooterWeightFactor();
                float totalWeight = (shooterWeight += HookShot.getWeight((Entity)shooter, (boolean)true)) + (targetWeight = HookShot.getWeight((Entity)hookedEntity, (boolean)true));
                if (totalWeight == 0.0f) {
                    totalWeight = 1.0f;
                }
                this.addMotionTo(hookedEntity, tensionVec.invert().scale((double)(shooterWeight / totalWeight)));
                this.addMotionTo((Entity)shooter, tensionVec.scale((double)(targetWeight / totalWeight)));
                break;
            }
        }
        ropeLength = ropeLengthBounds.enclose(Float.valueOf(ropeLength)).floatValue();
        if (this.isServerSide()) {
            this.setRopeLength(ropeLength);
            this.setSagging(ropeLength - hookDistance);
            this.setState(state);
            this.setTensionForce(tensionForce);
        }
    }

    protected void setTensionForce(float tensionForce) {
        if (this.isServerSide()) {
            this.setSynchedData(SynchedFloats.TENSION_FORCE, tensionForce);
        }
    }

    public float getHookDistance() {
        return (float)this.getLauncherPosition().distance(this.getCurPosition());
    }

    protected void updateControlling() {
        if (!this.isServerSide()) {
            return;
        }
        HookType hookType = this.getHookType();
        LivingEntity shooter = this.getShooter().orElse(null);
        InteractionHand launcherHand = this.getLauncherHand().orElse(null);
        if (hookType == null || shooter == null || launcherHand == null) {
            return;
        }
        State state = this.getState();
        float ropeLength = this.getRopeLength();
        float pullingSpeed = hookType.launcher.getReelingSpeed();
        if (this.getSynchedData(SynchedBools.DOUBLE_JUMPING) && !shooter.m_20096_() && (CommonMath.notZero((double)this.getTensionForce()) || ropeLength <= this.getHookDistance())) {
            boolean properlyAttached;
            switch (state) {
                case HOOKING_ENTITY: {
                    boolean bl = this.findHookedEntity().map(entity -> entity.m_20186_() > shooter.m_20186_()).orElse(false);
                    break;
                }
                case HOOKING_BLOCK: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = properlyAttached = false;
                }
            }
            if (properlyAttached) {
                this.doTarzanJump();
                this.doJumpBoost();
                this.setState(State.REELING);
                return;
            }
        }
        switch (state) {
            case HOOKING_BLOCK: 
            case HOOKING_ENTITY: {
                if (this.isPulling()) {
                    ropeLength -= pullingSpeed;
                }
                if (hookType == HookType.PUDGE) {
                    ropeLength -= pullingSpeed * 2.0f;
                    break;
                }
                if (!this.isLoosening()) break;
                ropeLength += pullingSpeed;
            }
        }
        if (this.getSynchedData(SynchedBools.UNHOOKING)) {
            ropeLength -= (pullingSpeed *= 4.0f);
            if (this.getSynchedData(SynchedBools.JUMPING) && state == State.HOOKING_BLOCK && (CommonMath.notZero((double)this.getTensionForce()) || ropeLength <= this.getHookDistance())) {
                this.doJumpBoost();
            }
            this.setState(State.REELING);
            return;
        }
        if (state == State.HOOKING_BLOCK && shooter.m_20142_() && CommonMath.notZero((double)this.getTensionForce())) {
            ropeLength += pullingSpeed;
        }
        if (ropeLength < 0.0f) {
            ropeLength = 0.0f;
        }
        this.setRopeLength(ropeLength);
    }

    public Rope getRope() {
        return this.getHookType().rope;
    }

    public Launcher getLauncher() {
        return this.getHookType().launcher;
    }

    public Hook getHook() {
        return this.getHookType().hook;
    }

    protected void addMotionTo(Entity entity, Vect3d motion) {
        if (motion.isZero()) {
            return;
        }
        EntityTarget target = MotionControllers.getTarget(entity.m_20201_()).orElse(null);
        if (target != null) {
            target.addDampedMotion(motion);
            if (HookShot.isClientSide((Entity)entity) && target instanceof ClientPlayerTarget) {
                ((ClientPlayerTarget)target).updateSwinging();
            }
        }
    }

    public void m_20258_(CompoundTag compound) {
        this.m_146870_();
    }

    public boolean m_5829_() {
        return false;
    }

    public Optional<LivingEntity> getShooter() {
        Entity entity;
        if (this.shooter == null && (entity = (Entity)GameWorld.getEntity((Level)this.m_9236_(), (int)this.getSynchedData(SynchedInts.SHOOTER_ID)).orElse(null)) instanceof LivingEntity) {
            this.shooter = (LivingEntity)entity;
        }
        return Optional.ofNullable(this.shooter);
    }

    public Block getHookedBlock() {
        return this.m_9236_().m_8055_(this.getHookedBlockPos()).m_60734_();
    }

    public boolean hookedBlockExists() {
        return this.getHookedBlock() != Blocks.f_50016_;
    }

    public Optional<Entity> findHookedEntity() {
        return HookShot.getById((Level)this.m_9236_(), (int)this.getSynchedData(SynchedInts.HOOKED_ENTITY_ID));
    }

    public void m_8119_() {
        super.m_8119_();
        this.move();
        this.updateLauncherHand();
        this.updateControlling();
        this.updateCombustion();
        this.updatePhysics();
        this.updateCollisions();
        this.updateTargetState();
        this.updateMotion();
        this.updateRotation();
    }

    protected void updateCombustion() {
        if (this.isServerSide()) {
            double fireResistance = this.getHookType().hook.getResistance();
            boolean fireInfluenced = false;
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    fireInfluenced = this.m_9236_().m_8055_(this.getHookedBlockPos().m_121945_(this.hitSide)).m_60713_(Blocks.f_50083_);
                    break;
                }
                case HOOKING_ENTITY: {
                    fireInfluenced = this.findHookedEntity().map(Entity::m_6060_).orElse(false);
                    break;
                }
            }
            if (this.m_6060_()) {
                this.combustion.fire();
            }
            if (this.combustion.getFireInfluencedTime().inSeconds() > fireResistance) {
                this.combustion.fire();
            }
            if (this.combustion.isBurning()) {
                this.m_20254_(1);
            }
            if (this.combustion.getBurningTime().inSeconds() > fireResistance) {
                this.m_6074_();
            }
            this.combustion.update(fireInfluenced);
        }
    }

    protected void updateCollisions() {
        if (!this.isServerSide()) {
            return;
        }
        State state = this.getState();
        if (this.isHookingTarget()) {
            return;
        }
        if (state == State.REELING) {
            if (!this.canHookOnReeling()) {
                return;
            }
            if (this.getHookType() == HookType.PUDGE && this.getPrevState() == State.HOOKING_ENTITY) {
                return;
            }
        }
        ArrayList<EntityHitResult> allHits = new ArrayList<EntityHitResult>();
        ClipContext.Block blockMode = this.getHookType() == HookType.PUDGE && state == State.REELING ? ClipContext.Block.OUTLINE : ClipContext.Block.COLLIDER;
        GameWorld.rayTraceBlocks((Level)this.m_9236_(), (Vect3d)this.getPrevPosition(), (Vect3d)this.getCurPosition(), (ClipContext.Block)blockMode, (ClipContext.Fluid)ClipContext.Fluid.NONE, (Entity)this).ifPresent(allHits::add);
        AABB aabb = this.getBB().m_82369_(this.m_20184_()).m_82400_(1.0);
        List entities = this.m_9236_().m_45933_((Entity)this, aabb);
        Entity shooter = this.getShooter().orElse(null);
        Entity vehicle = shooter != null ? shooter.m_20202_() : null;
        for (Entity target : entities) {
            Optional hit;
            if (target == shooter && state == State.REELING) {
                this.m_146870_();
                return;
            }
            if (!this.isServerSide() || target == this || target == shooter || target == vehicle || !(hit = HookShot.getBB((Entity)target).m_82400_((double)target.m_6143_()).m_82400_(0.2).m_82371_(this.getCurPosition().toVector3d(), this.getNextPosition().toVector3d())).isPresent()) continue;
            allHits.add(new EntityHitResult(target, HookShot.getCenterPosition((Entity)target).toVector3d()));
        }
        HitResult nearestHit = null;
        double minDistance = Double.MAX_VALUE;
        for (HitResult hitResult : allHits) {
            double distance = this.getCurPosition().distance(Vect3d.from((Vec3)hitResult.m_82450_()));
            if (!(distance < minDistance)) continue;
            nearestHit = hitResult;
            minDistance = distance;
        }
        if (nearestHit != null) {
            this.onTargetHit(nearestHit);
        }
    }

    protected void updateTargetState() {
        if (this.isServerSide()) {
            switch (this.getState()) {
                case HOOKING_BLOCK: {
                    if (this.hookedBlockExists()) break;
                    this.setState(State.REELING);
                    break;
                }
                case HOOKING_ENTITY: {
                    Entity entity = this.findHookedEntity().orElse(null);
                    if (!(entity == null || !entity.m_6084_() || entity instanceof LivingEntity && ((LivingEntity)entity).f_20911_ && entity.m_6047_() || entity instanceof Player && entity.m_20159_() && ((Player)entity).f_20911_) && !HookShot.hasSwingingPlayerPassenger((Entity)entity)) break;
                    this.setState(State.REELING);
                    break;
                }
            }
        }
    }

    public boolean isHookingTarget() {
        return switch (this.getState()) {
            case State.HOOKING_BLOCK, State.HOOKING_ENTITY -> true;
            default -> false;
        };
    }

    protected void updateRotation() {
        if (this.isHookingTarget()) {
            this.setAllRotations(this.getCurRotation());
        } else if (this.isClientSide()) {
            Vect3d motion = this.getCurMotion();
            if (this.getState() == State.REELING) {
                motion = motion.invert();
            }
            if (motion.notZero()) {
                Rotation rotation = motion.rotation();
                if (Mth.m_14205_((double)this.m_146908_()) != Mth.m_14205_((double)rotation.yaw)) {
                    this.f_19859_ = rotation.yaw;
                }
                this.setCurRotation(rotation);
            }
        }
    }

    protected void updateMotion() {
        State state = this.getState();
        switch (state) {
            case HOOKING_BLOCK: {
                if (!this.hookedBlockExists()) break;
                this.setAllPositions(this.getHitPosition());
                this.stopMoving();
                this.m_6853_(true);
                break;
            }
            case HOOKING_ENTITY: {
                if (!this.m_20159_()) {
                    this.findHookedEntity().ifPresent(entity -> {
                        this.stopMoving();
                        this.m_7998_((Entity)entity, true);
                        if (this.getHookType() == HookType.PUDGE) {
                            entity.m_8127_();
                        }
                    });
                }
                this.m_6853_(true);
                break;
            }
            default: {
                if (this.m_20159_()) {
                    this.m_8127_();
                }
                this.m_6853_(true);
                double motionFactor = 0.99f;
                if (this.m_20069_()) {
                    Vect3d bubblePos = this.getCurPosition().subtract(this.getCurMotion().scale(0.25));
                    for (int i = 0; i < 4; ++i) {
                        GameWorld.spawnParticle((Level)this.m_9236_(), (Vect3d)bubblePos, (Vect3d)this.getCurMotion(), (ParticleOptions)ParticleTypes.f_123795_);
                    }
                    motionFactor = 0.8f;
                }
                this.m_20256_(this.m_20184_().m_82490_(motionFactor).m_82520_(0.0, (double)-0.005f, 0.0));
            }
        }
    }

    public void launch(Vec3 direction, float velocity, float inaccuracy) {
        Vect3d motion = Vect3d.from((Vec3)direction).scale((double)velocity);
        this.setMotion(motion);
        Rotation rotation = new Rotation(motion.pitch(), motion.yaw());
        this.setAllRotations(rotation);
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 1.2f) + 0.5f);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof Player) {
            Inventory inventory = ((Player)shooter).m_150109_();
            Launcher.findAttachedLauncher(inventory, this).ifPresent(Launcher::unattach);
        }
        super.m_142687_(reason);
    }

    public float getTensionForce() {
        return this.getSynchedData(SynchedFloats.TENSION_FORCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        return distance < 65025.0;
    }

    protected void doJumpBoost() {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof ServerPlayer) {
            float strength = this.getLauncher().getJumpBoostStrength();
            new JumpBoostMsg(strength).sendTo((ServerPlayer)shooter);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    public void doTarzanJump() {
        LivingEntity shooter = this.getShooter().orElse(null);
        if (shooter instanceof ServerPlayer) {
            float strength = this.getLauncher().getTarzanJumpStrength();
            new TarzanJumpMsg(strength).sendTo((ServerPlayer)shooter);
            HookShot.setFallDistance((Entity)shooter, (float)0.0f, (boolean)true);
        }
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public static enum SynchedInts {
        HOOKED_BLOCK_X,
        HOOKED_BLOCK_Y,
        HOOKED_BLOCK_Z,
        HOOKED_ENTITY_ID,
        HOOK_TYPE,
        PREV_STATE,
        SHOOTER_ID,
        STATE,
        LAUNCHER_HAND;

    }

    public static enum SynchedBools implements IForgeEnum
    {
        LAUNCHING,
        PULLING,
        LOOSENING,
        UNHOOKING,
        JUMPING,
        DOUBLE_JUMPING;

    }

    public static enum State {
        SHOOTING,
        REELING,
        HOOKING_BLOCK,
        HOOKING_ENTITY;

    }

    public static enum SynchedFloats {
        HIT_X,
        HIT_Y,
        HIT_Z,
        ROPE_LENGTH,
        SAGGING,
        TENSION_FORCE;

    }

    protected static enum BlockAction {
        BOUNCE,
        BREAK,
        HOOK,
        PASS;

    }
}

