/*
 * Decompiled with CFR 0.152.
 */
package ballistix.api.missile;

import ballistix.api.capability.CapabilityActiveBullets;
import ballistix.api.capability.CapabilityActiveMissiles;
import ballistix.api.capability.CapabilityActiveRailgunRounds;
import ballistix.api.capability.CapabilityActiveSAMs;
import ballistix.api.missile.virtual.VirtualMissile;
import ballistix.api.missile.virtual.VirtualProjectile;
import ballistix.registers.BallistixCapabilities;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="ballistix", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MissileManager {
    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        LazyOptional lazyOptional;
        LazyOptional lazyOptionalRailgun;
        LazyOptional lazyOptionalBullets;
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_MISSILES);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveMissiles missiles = (CapabilityActiveMissiles)lazyOptionalMissiles.resolve().get();
            for (Map.Entry<ResourceKey<Level>, HashMap<UUID, VirtualMissile>> entry : missiles.activeMissiles.entrySet()) {
                ServerLevel serverLevel = event.getServer().m_129880_(entry.getKey());
                if (serverLevel == null) continue;
                Iterator<Map.Entry<UUID, VirtualMissile>> iterator = entry.getValue().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<UUID, VirtualMissile> active = iterator.next();
                    active.getValue().tick(serverLevel);
                    if (!active.getValue().hasExploded()) continue;
                    iterator.remove();
                }
            }
        }
        if ((lazyOptionalBullets = overworld.getCapability(BallistixCapabilities.ACTIVE_BULLETS)).isPresent()) {
            CapabilityActiveBullets bullets = (CapabilityActiveBullets)lazyOptionalBullets.resolve().get();
            for (Map.Entry<ResourceKey<Level>, HashMap<UUID, VirtualProjectile.VirtualBullet>> entry : bullets.activeBullets.entrySet()) {
                ServerLevel serverLevel = event.getServer().m_129880_(entry.getKey());
                if (serverLevel == null) continue;
                Iterator<Map.Entry<UUID, VirtualProjectile.VirtualBullet>> it = entry.getValue().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, VirtualProjectile.VirtualBullet> active = it.next();
                    active.getValue().tick(serverLevel);
                    if (!active.getValue().hasExploded()) continue;
                    it.remove();
                }
            }
        }
        if ((lazyOptionalRailgun = overworld.getCapability(BallistixCapabilities.ACTIVE_RAILGUN_ROUNDS)).isPresent()) {
            CapabilityActiveRailgunRounds capabilityActiveRailgunRounds = (CapabilityActiveRailgunRounds)lazyOptionalRailgun.resolve().get();
            for (Map.Entry<ResourceKey<Level>, HashMap<UUID, VirtualProjectile.VirtualRailgunRound>> entry : capabilityActiveRailgunRounds.activeRailgunRounds.entrySet()) {
                ServerLevel level = event.getServer().m_129880_(entry.getKey());
                if (level == null) continue;
                Iterator<Map.Entry<UUID, VirtualProjectile.VirtualRailgunRound>> it = entry.getValue().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, VirtualProjectile.VirtualRailgunRound> active = it.next();
                    active.getValue().tick(level);
                    if (!active.getValue().hasExploded()) continue;
                    it.remove();
                }
            }
        }
        if ((lazyOptional = overworld.getCapability(BallistixCapabilities.ACTIVE_SAMS)).isPresent()) {
            CapabilityActiveSAMs capabilityActiveSAMs = (CapabilityActiveSAMs)lazyOptional.resolve().get();
            for (Map.Entry<ResourceKey<Level>, HashMap<UUID, VirtualProjectile.VirtualSAM>> entry : capabilityActiveSAMs.activeSAMs.entrySet()) {
                ServerLevel level = event.getServer().m_129880_(entry.getKey());
                if (level == null) continue;
                Iterator<Map.Entry<UUID, VirtualProjectile.VirtualSAM>> it = entry.getValue().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, VirtualProjectile.VirtualSAM> active = it.next();
                    active.getValue().tick(level);
                    if (!active.getValue().hasExploded()) continue;
                    it.remove();
                }
            }
        }
    }

    public static void addMissile(ResourceKey<Level> key, VirtualMissile missile) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_MISSILES);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveMissiles missiles = (CapabilityActiveMissiles)lazyOptionalMissiles.resolve().get();
            HashMap<UUID, VirtualMissile> virtual = missiles.activeMissiles.getOrDefault(key, new HashMap());
            virtual.put(missile.getId(), missile);
            missiles.activeMissiles.put(key, virtual);
        }
    }

    public static void removeMissile(ResourceKey<Level> level, UUID id) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_MISSILES);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveMissiles missiles = (CapabilityActiveMissiles)lazyOptionalMissiles.resolve().get();
            HashMap virtual = missiles.activeMissiles.getOrDefault(level, new HashMap());
            virtual.remove(id);
        }
    }

    public static Collection<VirtualMissile> getMissilesForLevel(ResourceKey<Level> level) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_MISSILES);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveMissiles missiles = (CapabilityActiveMissiles)lazyOptionalMissiles.resolve().get();
            HashMap virtual = missiles.activeMissiles.getOrDefault(level, new HashMap());
            return virtual.values();
        }
        return new HashSet<VirtualMissile>();
    }

    @Nullable
    public static VirtualMissile getMissile(ResourceKey<Level> level, UUID id) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_MISSILES);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveMissiles missiles = (CapabilityActiveMissiles)lazyOptionalMissiles.resolve().get();
            HashMap virtual = missiles.activeMissiles.getOrDefault(level, new HashMap());
            return (VirtualMissile)virtual.get(id);
        }
        return null;
    }

    public static void wipeAllMissiles() {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_MISSILES);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveMissiles missiles = (CapabilityActiveMissiles)lazyOptionalMissiles.resolve().get();
            missiles.activeMissiles.clear();
        }
    }

    public static void addBullet(ResourceKey<Level> key, VirtualProjectile.VirtualBullet bullet) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalBullets = overworld.getCapability(BallistixCapabilities.ACTIVE_BULLETS);
        if (lazyOptionalBullets.isPresent()) {
            CapabilityActiveBullets bullets = (CapabilityActiveBullets)lazyOptionalBullets.resolve().get();
            HashMap<UUID, VirtualProjectile.VirtualBullet> virtual = bullets.activeBullets.getOrDefault(key, new HashMap());
            virtual.put(bullet.id, bullet);
            bullets.activeBullets.put(key, virtual);
        }
    }

    @Nullable
    public static VirtualProjectile.VirtualBullet getBullet(ResourceKey<Level> level, UUID id) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalBullets = overworld.getCapability(BallistixCapabilities.ACTIVE_BULLETS);
        if (lazyOptionalBullets.isPresent()) {
            CapabilityActiveBullets bullets = (CapabilityActiveBullets)lazyOptionalBullets.resolve().get();
            HashMap virtual = bullets.activeBullets.getOrDefault(level, new HashMap());
            return (VirtualProjectile.VirtualBullet)virtual.get(id);
        }
        return null;
    }

    public static Collection<VirtualProjectile.VirtualBullet> getBulletsForLevel(ResourceKey<Level> level) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_BULLETS);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveBullets bullets = (CapabilityActiveBullets)lazyOptionalMissiles.resolve().get();
            HashMap virtual = bullets.activeBullets.getOrDefault(level, new HashMap());
            return virtual.values();
        }
        return new HashSet<VirtualProjectile.VirtualBullet>();
    }

    public static void wipeAllBullets() {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalBullets = overworld.getCapability(BallistixCapabilities.ACTIVE_BULLETS);
        if (lazyOptionalBullets.isPresent()) {
            CapabilityActiveBullets bullets = (CapabilityActiveBullets)lazyOptionalBullets.resolve().get();
            bullets.activeBullets.clear();
        }
    }

    public static void addRailgunRound(ResourceKey<Level> key, VirtualProjectile.VirtualRailgunRound railgun) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalRailgun = overworld.getCapability(BallistixCapabilities.ACTIVE_RAILGUN_ROUNDS);
        if (lazyOptionalRailgun.isPresent()) {
            CapabilityActiveRailgunRounds railgunrounds = (CapabilityActiveRailgunRounds)lazyOptionalRailgun.resolve().get();
            HashMap<UUID, VirtualProjectile.VirtualRailgunRound> virtual = railgunrounds.activeRailgunRounds.getOrDefault(key, new HashMap());
            virtual.put(railgun.id, railgun);
            railgunrounds.activeRailgunRounds.put(key, virtual);
        }
    }

    @Nullable
    public static VirtualProjectile.VirtualRailgunRound getRailgunRound(ResourceKey<Level> level, UUID id) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalRailgun = overworld.getCapability(BallistixCapabilities.ACTIVE_RAILGUN_ROUNDS);
        if (lazyOptionalRailgun.isPresent()) {
            CapabilityActiveRailgunRounds railgunrounds = (CapabilityActiveRailgunRounds)lazyOptionalRailgun.resolve().get();
            HashMap virtual = railgunrounds.activeRailgunRounds.getOrDefault(level, new HashMap());
            return (VirtualProjectile.VirtualRailgunRound)virtual.get(id);
        }
        return null;
    }

    public static Collection<VirtualProjectile.VirtualRailgunRound> getRailgunRoundsForLevel(ResourceKey<Level> level) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_RAILGUN_ROUNDS);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveRailgunRounds rounds = (CapabilityActiveRailgunRounds)lazyOptionalMissiles.resolve().get();
            HashMap virtual = rounds.activeRailgunRounds.getOrDefault(level, new HashMap());
            return virtual.values();
        }
        return new HashSet<VirtualProjectile.VirtualRailgunRound>();
    }

    public static void wipeAllRailgunRounds() {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalRailgun = overworld.getCapability(BallistixCapabilities.ACTIVE_RAILGUN_ROUNDS);
        if (lazyOptionalRailgun.isPresent()) {
            CapabilityActiveRailgunRounds railgunrounds = (CapabilityActiveRailgunRounds)lazyOptionalRailgun.resolve().get();
            railgunrounds.activeRailgunRounds.clear();
        }
    }

    public static void addSAM(ResourceKey<Level> key, VirtualProjectile.VirtualSAM bullet) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalSAMs = overworld.getCapability(BallistixCapabilities.ACTIVE_SAMS);
        if (lazyOptionalSAMs.isPresent()) {
            CapabilityActiveSAMs sams = (CapabilityActiveSAMs)lazyOptionalSAMs.resolve().get();
            HashMap<UUID, VirtualProjectile.VirtualSAM> virtual = sams.activeSAMs.getOrDefault(key, new HashMap());
            virtual.put(bullet.id, bullet);
            sams.activeSAMs.put(key, virtual);
        }
    }

    @Nullable
    public static VirtualProjectile.VirtualSAM getSAM(ResourceKey<Level> level, UUID id) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalSAMs = overworld.getCapability(BallistixCapabilities.ACTIVE_SAMS);
        if (lazyOptionalSAMs.isPresent()) {
            CapabilityActiveSAMs sams = (CapabilityActiveSAMs)lazyOptionalSAMs.resolve().get();
            HashMap virtual = sams.activeSAMs.getOrDefault(level, new HashMap());
            return (VirtualProjectile.VirtualSAM)virtual.get(id);
        }
        return null;
    }

    public static Collection<VirtualProjectile.VirtualSAM> getSAMsForLevel(ResourceKey<Level> level) {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalMissiles = overworld.getCapability(BallistixCapabilities.ACTIVE_SAMS);
        if (lazyOptionalMissiles.isPresent()) {
            CapabilityActiveSAMs rounds = (CapabilityActiveSAMs)lazyOptionalMissiles.resolve().get();
            HashMap virtual = rounds.activeSAMs.getOrDefault(level, new HashMap());
            return virtual.values();
        }
        return new HashSet<VirtualProjectile.VirtualSAM>();
    }

    public static void wipeAllSAMs() {
        ServerLevel overworld = MissileManager.getOverworld();
        LazyOptional lazyOptionalSAMs = overworld.getCapability(BallistixCapabilities.ACTIVE_SAMS);
        if (lazyOptionalSAMs.isPresent()) {
            CapabilityActiveSAMs sams = (CapabilityActiveSAMs)lazyOptionalSAMs.resolve().get();
            sams.activeSAMs.clear();
        }
    }

    private static ServerLevel getOverworld() {
        return ServerLifecycleHooks.getCurrentServer().m_129783_();
    }
}

