/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.tier3;

import ballistix.api.blast.IBlast;
import ballistix.api.blast.IHasCustomRender;
import ballistix.client.particle.ParticleOptionsShockwave;
import ballistix.common.blast.util.Blast;
import ballistix.common.block.subtype.SubtypeBlast;
import ballistix.common.settings.BallistixConstants;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;

public class BlastEnder
extends Blast
implements IHasCustomRender {
    public BlastEnder(Level world, BlockPos position) {
        super(world, position);
    }

    @Override
    public IBlast getBlastType() {
        return SubtypeBlast.ender;
    }

    @Override
    public boolean doExplode(int callCount) {
        super.doExplode(callCount);
        this.hasStarted = true;
        if (this.world.f_46443_) {
            this.produceParticles();
            return true;
        }
        float x = this.position.m_123341_();
        float y = this.position.m_123342_();
        float z = this.position.m_123343_();
        float size = 7.0f;
        float f2 = size * 2.0f;
        int x0 = Mth.m_14107_((double)((double)x - (double)f2 - 1.0));
        int x1 = Mth.m_14107_((double)((double)x + (double)f2 + 1.0));
        int y0 = Mth.m_14107_((double)((double)y - (double)f2 - 1.0));
        int y1 = Mth.m_14107_((double)((double)y + (double)f2 + 1.0));
        int z0 = Mth.m_14107_((double)((double)z - (double)f2 - 1.0));
        int z1 = Mth.m_14107_((double)((double)z + (double)f2 + 1.0));
        List entities = this.world.m_45976_(LivingEntity.class, new AABB((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        block3: for (LivingEntity entity : entities) {
            switch (this.griefPreventionMethod) {
                case GRIEF_DEFENDER: {
                    if (GriefDefenderHandler.shouldEntityBeHarmed((Entity)entity)) break;
                    continue block3;
                }
            }
            if (this.world.m_46472_().equals((Object)Level.f_46430_)) {
                entity.m_264318_(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46428_), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Collections.emptySet(), entity.m_146908_(), entity.m_146909_());
                continue;
            }
            entity.m_264318_(ServerLifecycleHooks.getCurrentServer().m_129880_(Level.f_46430_), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Collections.emptySet(), entity.m_146908_(), entity.m_146909_());
        }
        for (int i = 0; i < BallistixConstants.EXPLOSIVE_ENDER_ENDERMANCOUNT; ++i) {
            LivingEntity entity;
            entity = new EnderMan(EntityType.f_20566_, this.world);
            entity.m_6034_((double)(this.position.m_123341_() + this.world.f_46441_.m_216332_((int)(-BallistixConstants.EXPLOSIVE_ENDER_RADIUS), (int)BallistixConstants.EXPLOSIVE_ENDER_RADIUS)), (double)(this.position.m_123342_() + this.world.f_46441_.m_216332_((int)(-BallistixConstants.EXPLOSIVE_ENDER_RADIUS), (int)BallistixConstants.EXPLOSIVE_ENDER_RADIUS)), (double)(this.position.m_123343_() + this.world.f_46441_.m_216332_((int)(-BallistixConstants.EXPLOSIVE_ENDER_RADIUS), (int)BallistixConstants.EXPLOSIVE_ENDER_RADIUS)));
            this.world.m_7967_((Entity)entity);
        }
        this.world.m_254849_(null, (double)this.position.m_123341_() + 0.5, (double)this.position.m_123342_() + 0.5, (double)this.position.m_123343_() + 0.5, (float)BallistixConstants.EXPLOSIVE_ENDER_RADIUS, Level.ExplosionInteraction.BLOCK);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void produceParticles() {
        float x = (float)this.position.m_123341_() + 0.5f;
        float y = (float)this.position.m_123342_() + 0.5f;
        float z = (float)this.position.m_123343_() + 0.5f;
        float size = 7.0f;
        float f2 = size * 2.0f;
        int x0 = Mth.m_14107_((double)((double)(x - f2) - 1.0));
        int x1 = Mth.m_14107_((double)((double)(x + f2) + 1.0));
        int y0 = Mth.m_14107_((double)((double)(y - f2) - 1.0));
        int y1 = Mth.m_14107_((double)((double)(y + f2) + 1.0));
        int z0 = Mth.m_14107_((double)((double)(z - f2) - 1.0));
        int z1 = Mth.m_14107_((double)((double)(z + f2) + 1.0));
        for (int dx = x0; dx < x1; ++dx) {
            for (int dy = y0; dy < y1; ++dy) {
                for (int dz = z0; dz < z1; ++dz) {
                    if (!((x - (float)dx) * (x - (float)dx) + (y - (float)dy) * (y - (float)dy) + (z - (float)dz) * (z - (float)dz) <= (2.0f * size + 1.0f) * (2.0f * size + 1.0f)) || !((double)this.world.f_46441_.m_188501_() < 0.025)) continue;
                    ParticleOptionsShockwave particle = new ParticleOptionsShockwave().setParameters(0.933f, 0.212f, 0.933f, 1.0f, 0.1f, 15, false, 1.0);
                    Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)particle, (double)dx, (double)dy, (double)dz, (double)(x - (float)dx) / 15.0, (double)(y - (float)dy) / 15.0, (double)(z - (float)dz) / 15.0);
                }
            }
        }
    }
}

