/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.util.thread;

import ballistix.common.blast.util.thread.ThreadBlast;
import ballistix.common.settings.BallistixConstants;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import voltaic.Voltaic;
import voltaic.prefab.block.HashDistanceBlockPos;

public class ThreadSimpleBlast
extends ThreadBlast {
    private static final HashMap<ResourceLocation, HashSet<BlockPos>> CACHED_EUCLIDEAN_RESULTS = new HashMap();
    private static final Set<Integer> currentlyCalculating = Collections.synchronizedSet(new HashSet());
    private final ResourceLocation id;
    public double strictnessAtEdges = 1.85;

    public ThreadSimpleBlast(Level world, BlockPos position, int range, float energy, Entity source, ResourceLocation id) {
        super(world, position, range, energy, source);
        this.setName("Simple blast thread");
        this.id = id;
        this.setPriority(10);
    }

    @Override
    public void run() {
        int explosionRadius = this.explosionRadius;
        Random random = Voltaic.RANDOM;
        this.runEuclidian(explosionRadius, random);
        super.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runEuclidian(int explosionRadius, Random random) {
        if (BallistixConstants.SHOULD_CACHE_EXPLOSIONS) {
            Set<Integer> set = currentlyCalculating;
            synchronized (set) {
                while (currentlyCalculating.contains(explosionRadius)) {
                    try {
                        ThreadSimpleBlast.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                if (CACHED_EUCLIDEAN_RESULTS.get(this.id) == null) {
                    currentlyCalculating.add(explosionRadius);
                }
            }
            if (CACHED_EUCLIDEAN_RESULTS.get(this.id) == null) {
                int rSqrd = explosionRadius * explosionRadius;
                ArrayList<Object> positions = new ArrayList<Object>((int)(4.1887902047863905 * (double)rSqrd * (double)(explosionRadius + 1)));
                for (int i = -explosionRadius; i <= explosionRadius; ++i) {
                    for (int j = 0; j <= explosionRadius; ++j) {
                        int dist2D = i * i + j * j;
                        if (dist2D > rSqrd) continue;
                        int kMax = (int)Math.floor(Math.sqrt(rSqrd - dist2D));
                        for (int k = 0; k <= kMax; ++k) {
                            int dist3D = dist2D + k * k;
                            if (!((double)(random.nextFloat() * (float)rSqrd) < (double)rSqrd * this.strictnessAtEdges - (double)dist3D)) continue;
                            positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                            if (k != 0) {
                                positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                                if (j != 0) {
                                    positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                                }
                            }
                            if (j == 0) continue;
                            positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                        }
                    }
                }
                Random rand = Voltaic.RANDOM;
                for (int i = 0; i < positions.size(); ++i) {
                    int newIndex = rand.nextInt(Math.max(0, i - 10), Math.min(positions.size() - 1, i + 10));
                    BlockPos atNew = (BlockPos)positions.get(newIndex);
                    positions.set(newIndex, (BlockPos)positions.get(i));
                    positions.set(i, atNew);
                }
                CACHED_EUCLIDEAN_RESULTS.put(this.id, Sets.newHashSet(positions));
            }
            this.results = CACHED_EUCLIDEAN_RESULTS.get(this.id);
            Set<Integer> rSqrd = currentlyCalculating;
            synchronized (rSqrd) {
                currentlyCalculating.remove(explosionRadius);
            }
        }
        int rSqrd = explosionRadius * explosionRadius;
        ArrayList<Object> positions = new ArrayList<Object>((int)(4.1887902047863905 * (double)rSqrd * (double)(explosionRadius + 1)));
        for (int i = -explosionRadius; i <= explosionRadius; ++i) {
            for (int j = 0; j <= explosionRadius; ++j) {
                int dist2D = i * i + j * j;
                if (dist2D > rSqrd) continue;
                int kMax = (int)Math.floor(Math.sqrt(rSqrd - dist2D));
                for (int k = 0; k <= kMax; ++k) {
                    int dist3D = dist2D + k * k;
                    if (!((double)(random.nextFloat() * (float)rSqrd) < (double)rSqrd * this.strictnessAtEdges - (double)dist3D)) continue;
                    positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                    if (k != 0) {
                        positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)j, (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                        if (j != 0) {
                            positions.add(new HashDistanceBlockPos((double)i, (double)(-k), (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                        }
                    }
                    if (j == 0) continue;
                    positions.add(new HashDistanceBlockPos((double)i, (double)k, (double)(-j), (int)Math.max(1.0f, (float)(dist3D - 50) + random.nextFloat() * 100.0f)));
                }
            }
        }
        Random rand = Voltaic.RANDOM;
        for (int i = 0; i < positions.size(); ++i) {
            int newIndex = rand.nextInt(Math.max(0, i - 10), Math.min(positions.size() - 1, i + 10));
            BlockPos atNew = (BlockPos)positions.get(newIndex);
            positions.set(newIndex, (BlockPos)positions.get(i));
            positions.set(i, atNew);
        }
        this.results = Sets.newHashSet(positions);
    }
}

