/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.blast.util.thread.raycast;

import ballistix.common.blast.util.thread.ThreadBlast;
import ballistix.common.blast.util.thread.raycast.IResistanceCallback;
import ballistix.common.blast.util.thread.raycast.ThreadDynamicRaySideBlast;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.block.HashDistanceBlockPos;

public class ThreadDynamicRaycastBlast
extends ThreadBlast {
    public final IResistanceCallback callBack;
    public final HashSet<ThreadDynamicRaySideBlast> underBlasts = new HashSet();
    protected final Set<BlockPos> intermediateResults = Collections.synchronizedSet(new HashSet());
    public final Set<BlockPos> finishedBlocks = Collections.synchronizedSet(new HashSet());
    public boolean locked = false;

    public ThreadDynamicRaycastBlast(Level world, BlockPos position, int range, float energy, Entity source, IResistanceCallback cb) {
        super(world, position, range, energy, source);
        this.callBack = cb;
        this.setName("RaycastBlast Main Thread");
    }

    public ThreadDynamicRaycastBlast(Level world, BlockPos position, int range, float energy, Entity source) {
        this(world, position, range, energy, source, new IResistanceCallbackImp(new Explosion(world, source, null, null, (double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), (float)range, false, Explosion.BlockInteraction.DESTROY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.results.add(new HashDistanceBlockPos((double)this.position.m_123341_(), (double)this.position.m_123342_(), (double)this.position.m_123343_(), 0));
        for (Direction dir : Direction.values()) {
            ThreadDynamicRaySideBlast sideBlast = new ThreadDynamicRaySideBlast(this, dir);
            sideBlast.start();
            this.underBlasts.add(sideBlast);
        }
        while (!this.underBlasts.isEmpty()) {
            HashSet<BlockPos> current = new HashSet<BlockPos>();
            Set<BlockPos> set = this.intermediateResults;
            synchronized (set) {
                current.addAll(this.intermediateResults);
                this.intermediateResults.clear();
            }
            set = this.finishedBlocks;
            synchronized (set) {
                this.finishedBlocks.addAll(current);
            }
            try {
                ThreadDynamicRaycastBlast.sleep(25L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        super.run();
    }

    public record IResistanceCallbackImp(Explosion explosion) implements IResistanceCallback
    {
        @Override
        public float getResistance(Level world, BlockPos position, BlockPos targetPosition, Entity source, BlockState block) {
            if (!block.m_60819_().m_76178_()) {
                return 0.25f;
            }
            float resistance = block.getExplosionResistance((BlockGetter)world, position, this.explosion);
            if (resistance > 200.0f) {
                resistance = 0.75f * (float)Math.sqrt(resistance);
            }
            return resistance;
        }
    }
}

