/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.entity;

import ballistix.common.blast.util.Blast;
import ballistix.compatibility.griefdefender.GriefDefenderHandler;
import ballistix.registers.BallistixDamageTypes;
import ballistix.registers.BallistixEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;

public class EntityShrapnel
extends ThrowableProjectile {
    private static final EntityDataAccessor<Boolean> ISEXPLOSIVE = SynchedEntityData.m_135353_(EntityShrapnel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public boolean isExplosive = false;
    private final Blast.GriefPreventionMethod griefPreventionMethod = Blast.getGriefPreventionMethod();

    public EntityShrapnel(EntityType<? extends EntityShrapnel> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityShrapnel(Level worldIn) {
        this((EntityType<? extends EntityShrapnel>)((EntityType)BallistixEntities.ENTITY_SHRAPNEL.get()), worldIn);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(ISEXPLOSIVE, (Object)this.isExplosive);
        } else {
            this.isExplosive = (Boolean)this.f_19804_.m_135370_(ISEXPLOSIVE);
        }
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        EntityDimensions size = this.m_6972_(Pose.STANDING);
        this.m_20011_(new AABB(this.m_20185_() - (double)(size.f_20377_ * 2.0f), this.m_20186_() - (double)(size.f_20378_ * 2.0f), this.m_20189_() - (double)(size.f_20377_ * 2.0f), this.m_20185_() + (double)(size.f_20377_ * 2.0f), this.m_20186_() + (double)(size.f_20378_ * 2.0f), this.m_20189_() + (double)(size.f_20377_ * 2.0f)));
        if (this.m_20096_() || this.f_19797_ > (this.isExplosive ? 400 : 100) || this.m_9236_().m_8055_(this.m_20183_()).m_280555_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        switch (this.griefPreventionMethod) {
            case GRIEF_DEFENDER: {
                if (GriefDefenderHandler.shouldHarmBlock(this.m_20183_())) break;
                if (!this.m_9236_().f_46443_) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                return;
            }
        }
        if (!this.m_9236_().f_46443_) {
            List livings = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
            for (LivingEntity living : livings) {
                living.m_6469_(living.m_269291_().m_269079_(BallistixDamageTypes.SHRAPNEL), 10.0f);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public void m_37251_(@Nullable Entity entity, float pitch, float yaw, float par4, float force, float par6) {
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pitch + par4) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, force, par6);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("type", this.isExplosive);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ISEXPLOSIVE, (Object)false);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.isExplosive) {
            this.m_9236_().m_254877_((Entity)this, this.m_9236_().m_269111_().m_269079_(BallistixDamageTypes.SHRAPNEL), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, true, Level.ExplosionInteraction.BLOCK);
        }
        super.m_142687_(reason);
    }

    protected void m_7378_(CompoundTag compound) {
        this.isExplosive = compound.m_128471_("type");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

