/*
 * Decompiled with CFR 0.152.
 */
package ballistix.common.packet.type.client.particle;

import ballistix.common.packet.type.client.ClientBarrierMethods;
import ballistix.common.packet.type.client.particle.BlastParticleSpawnType;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import voltaic.api.codec.StreamCodec;

public class PacketSpawnBlastParticle {
    public static final StreamCodec<ByteBuf, PacketSpawnBlastParticle> CODEC = new StreamCodec<ByteBuf, PacketSpawnBlastParticle>(){

        public void encode(ByteBuf buf, PacketSpawnBlastParticle data) {
            StreamCodec.BLOCK_POS.encode((Object)buf, (Object)data.pos);
            buf.writeInt(data.type.ordinal());
        }

        public PacketSpawnBlastParticle decode(ByteBuf buf) {
            return new PacketSpawnBlastParticle((BlockPos)StreamCodec.BLOCK_POS.decode((Object)buf), BlastParticleSpawnType.values()[buf.readInt()]);
        }
    };
    private final BlockPos pos;
    private final BlastParticleSpawnType type;

    public PacketSpawnBlastParticle(BlockPos pos, BlastParticleSpawnType type) {
        this.pos = pos;
        this.type = type;
    }

    public static void handle(PacketSpawnBlastParticle message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> ClientBarrierMethods.handlerSpawnBlastParticle(message.pos, message.type));
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSpawnBlastParticle pkt, FriendlyByteBuf buf) {
        CODEC.encode((Object)buf, (Object)pkt);
    }

    public static PacketSpawnBlastParticle decode(FriendlyByteBuf buf) {
        return (PacketSpawnBlastParticle)CODEC.decode((Object)buf);
    }
}

