/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.joml.Vector4f;

public class SerializerVector4f
implements ISerializer<Vector4f> {
    public static final ISerializer<Vector4f> SERIALIZER = new SerializerVector4f();

    @Override
    public Vector4f fromJSON(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            float x = Serializers.FLOAT.fromJSON(object, "x").floatValue();
            float y = Serializers.FLOAT.fromJSON(object, "y").floatValue();
            float z = Serializers.FLOAT.fromJSON(object, "z").floatValue();
            float w = Serializers.FLOAT.fromJSON(object, "w").floatValue();
            return new Vector4f(x, y, z, w);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.size() == 4) {
                return new Vector4f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat(), array.get(3).getAsFloat());
            }
            throw new JsonParseException("Invalid number of args in array. Expected 4 but got " + array.size());
        }
        throw new JsonParseException("Vector4f data is not in a readable format.");
    }

    @Override
    public JsonElement toJSON(Vector4f toWrite) {
        JsonObject object = new JsonObject();
        object.addProperty("x", (Number)Float.valueOf(toWrite.x()));
        object.addProperty("y", (Number)Float.valueOf(toWrite.y()));
        object.addProperty("z", (Number)Float.valueOf(toWrite.z()));
        object.addProperty("w", (Number)Float.valueOf(toWrite.w()));
        return object;
    }

    @Override
    public Vector4f fromByteBuf(FriendlyByteBuf buffer) {
        return new Vector4f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Vector4f toWrite) {
        buffer.writeFloat(toWrite.x());
        buffer.writeFloat(toWrite.y());
        buffer.writeFloat(toWrite.z());
        buffer.writeFloat(toWrite.w());
    }

    @Override
    public Tag toNBT(Vector4f toWrite) {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_("x", toWrite.x());
        tag.m_128350_("y", toWrite.y());
        tag.m_128350_("z", toWrite.z());
        tag.m_128350_("w", toWrite.w());
        return tag;
    }

    @Override
    public Vector4f fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            float x = compound.m_128457_("x");
            float y = compound.m_128457_("y");
            float z = compound.m_128457_("z");
            float w = compound.m_128457_("w");
            return new Vector4f(x, y, z, w);
        }
        if (nbt instanceof ListTag) {
            ListTag list = (ListTag)nbt;
            if (list.size() == 4) {
                return new Vector4f(Serializers.FLOAT.fromNBT(list.get(0)).floatValue(), Serializers.FLOAT.fromNBT(list.get(1)).floatValue(), Serializers.FLOAT.fromNBT(list.get(2)).floatValue(), Serializers.FLOAT.fromNBT(list.get(3)).floatValue());
            }
            throw new NBTParseException("Invalid number of args in array. Expected 4 but got " + list.size());
        }
        throw new NBTParseException("Vector4f data is not in a readable format.");
    }
}

