/*
 * Decompiled with CFR 0.152.
 */
package dynamicelectricity.client.screen;

import dynamicelectricity.common.inventory.container.ContainerMotorAC;
import dynamicelectricity.common.tile.generic.TileMotorAC;
import dynamicelectricity.core.utils.UtilsText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.types.ScreenComponentMultiLabel;
import voltaic.prefab.screen.component.types.ScreenComponentProgress;
import voltaic.prefab.screen.component.types.gauges.ScreenComponentFluidGauge;
import voltaic.prefab.screen.component.types.guitab.ScreenComponentElectricInfo;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.screen.types.GenericMaterialScreen;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ScreenMotorAC
extends GenericMaterialScreen<ContainerMotorAC> {
    public ScreenMotorAC(ContainerMotorAC screenContainer, Inventory inv, Component titleIn) {
        super((GenericContainer)screenContainer, inv, titleIn);
        this.addComponent((AbstractScreenComponent)new ScreenComponentElectricInfo(this::getEnergyInformation, -25, 2));
        this.addComponent((AbstractScreenComponent)new ScreenComponentGeneric((ITexture)ScreenComponentProgress.ProgressTextures.ARROW_RIGHT_OFF, 123, 33));
        this.addComponent((AbstractScreenComponent)new ScreenComponentFluidGauge(() -> {
            TileMotorAC motor = (TileMotorAC)((ContainerMotorAC)this.f_97732_).getSafeHost();
            if (motor != null) {
                return (IFluidTank)motor.getComponent(IComponentType.FluidHandler);
            }
            return new FluidTank(1000);
        }, 150, 18));
        this.addComponent((AbstractScreenComponent)new ScreenComponentMultiLabel(0, 0, graphics -> {
            TileMotorAC motor = (TileMotorAC)((ContainerMotorAC)this.f_97732_).getSafeHost();
            if (motor == null) {
                return;
            }
            graphics.m_280614_(this.f_96547_, (Component)UtilsText.gui("motor.lubricant", new Object[0]).m_130940_(ChatFormatting.BLACK).m_7220_((Component)Component.m_237113_((String)("" + motor.lubricantRemaining.getValue())).m_130940_(ChatFormatting.DARK_GRAY)), this.f_97730_, 33, 0, false);
            graphics.m_280614_(this.f_96547_, (Component)UtilsText.gui("motor.generating", new Object[0]).m_130940_((Boolean)motor.running.getValue() != false ? ChatFormatting.GREEN : ChatFormatting.RED), this.f_97730_, 43, 0, false);
        }));
    }

    private List<? extends FormattedCharSequence> getEnergyInformation() {
        ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
        TileMotorAC box = (TileMotorAC)((ContainerMotorAC)this.f_97732_).getSafeHost();
        if (box != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)box.getComponent(IComponentType.Electrodynamic);
            list.add(UtilsText.gui("motor.usage", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)(electro.getMaxJoulesStored() / 20.0), (IDisplayUnit)DisplayUnits.JOULES), (Component)DisplayUnits.TIME_TICKS.getSymbol()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(UtilsText.gui("motor.wattage", ChatFormatter.getChatDisplayShort((double)electro.getMaxJoulesStored(), (IDisplayUnit)DisplayUnits.WATT).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(UtilsText.gui("motor.voltage", ChatFormatter.getChatDisplayShort((double)electro.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
            list.add(UtilsText.gui("motor.output", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)((Integer)box.feProduced.getValue()).intValue(), (IDisplayUnit)DisplayUnits.FORGE_ENERGY_UNIT), (Component)DisplayUnits.TIME_TICKS.getSymbol()).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY).m_7532_());
        }
        return list;
    }
}

