/*
 * Decompiled with CFR 0.152.
 */
package dynamicelectricity.common.tile.generic;

import dynamicelectricity.Config;
import dynamicelectricity.common.inventory.container.ContainerMotorDC;
import dynamicelectricity.common.tags.DynamicElectricityTags;
import dynamicelectricity.registry.DynamicElectricitySounds;
import electrodynamics.prefab.utilities.ElectricityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileMotorDC
extends GenericTile
implements IEnergyStorage,
ITickableSound {
    public static final double CONVERSION_EFFICIENCY = 0.95;
    public static final int LUBRICANT_PER_MB = 20000;
    public final SingleProperty<Integer> maxFeConsumed;
    public final SingleProperty<Integer> feStored;
    public final SingleProperty<Double> joulesProduced;
    public final SingleProperty<Integer> lubricantRemaining;
    public final SingleProperty<Boolean> running;
    public final SingleProperty<Boolean> hasRedstoneSignal;
    protected CachedTileOutput output;
    private boolean isPlaying = false;
    public final int energyTier;

    public TileMotorDC(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int feConsumed, int energyTier, String name) {
        super(tileEntityTypeIn, pos, state);
        this.energyTier = energyTier;
        this.maxFeConsumed = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "feconsumed", (Object)feConsumed));
        this.feStored = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "festored", (Object)0));
        this.joulesProduced = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "joulesproduced", (Object)((double)feConsumed * 0.95)));
        this.lubricantRemaining = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "lubricantremaining", (Object)0));
        this.running = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "running", (Object)false));
        this.hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}).voltage(Math.pow(2.0, energyTier) * 120.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1).bucketInputs(1)).valid(TileMotorDC.machineValidator()).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.TOP}));
        this.addComponent((IComponent)new ComponentContainerProvider("motordc" + name, (GenericTile)this).createMenu((id, player) -> new ContainerMotorDC((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(1000, (GenericTile)this, "lubricant").setValidFluidTags(new TagKey[]{DynamicElectricityTags.Fluids.LUBRICANT}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
    }

    public void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            this.running.setValue((Object)false);
            return;
        }
        ComponentInventory inventory = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        Direction facing = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.m_58899_().m_121945_(facing));
        }
        if (tickable.getTicks() % 20L == 0L) {
            this.output.update(this.f_58858_.m_121945_(facing));
        }
        boolean canRun = false;
        ItemStack brush = inventory.m_8020_(0);
        ComponentFluidHandlerSimple tank = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        if (!brush.m_41619_() && (Integer)this.feStored.getValue() >= (Integer)this.maxFeConsumed.getValue()) {
            if (Config.useConductorBrushDurability) {
                brush.m_41721_(brush.m_41773_() + 1);
            }
            if ((Integer)this.lubricantRemaining.getValue() > 0) {
                this.lubricantRemaining.setValue((Object)((Integer)this.lubricantRemaining.getValue() - 1));
                canRun = true;
            } else if ((Integer)this.lubricantRemaining.getValue() == 0 && tank.getFluidAmount() > 0) {
                tank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.lubricantRemaining.setValue((Object)20000);
            }
        }
        if (brush.m_41773_() >= brush.m_41776_() && canRun) {
            brush.m_41774_(1);
            inventory.m_6836_(0, brush);
        }
        FluidUtilities.drainItem((GenericTile)this, (FluidTank[])tank.asArray());
        this.running.setValue((Object)canRun);
        if (!canRun) {
            return;
        }
        this.feStored.setValue((Object)0);
        if (this.output.valid()) {
            TransferPack pack = TransferPack.joulesVoltage((double)((Double)this.joulesProduced.getValue()), (double)electro.getVoltage());
            ElectricityUtils.receivePower((BlockEntity)((BlockEntity)this.output.getSafe()), (Direction)facing.m_122424_(), (TransferPack)pack, (boolean)false);
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.shouldPlaySound() && !this.isPlaying) {
            this.isPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)DynamicElectricitySounds.SOUND_MOTORRUNNING.get()), (BlockEntity)this, (boolean)true);
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == this.getFacing().m_122424_()) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int feAdded;
        int room = (Integer)this.maxFeConsumed.getValue() - (Integer)this.feStored.getValue();
        int n = feAdded = room >= maxReceive ? maxReceive : room;
        if (!simulate) {
            this.feStored.setValue((Object)((Integer)this.feStored.getValue() + feAdded));
        }
        return room;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (Integer)this.feStored.getValue();
    }

    public int getMaxEnergyStored() {
        return (Integer)this.maxFeConsumed.getValue();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public void setNotPlaying() {
        this.isPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.running.getValue();
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }
}

