/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.common.tile.machines.TileChemicalMixer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.utilities.RenderingUtils;
import voltaic.prefab.utilities.math.MathUtils;

public class RenderChemicalMixer
extends AbstractTileRenderer<TileChemicalMixer> {
    public RenderChemicalMixer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(@NotNull TileChemicalMixer tileEntityIn, float partialTicks, PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BakedModel ibakedmodel = this.getModel(ElectrodynamicsClientRegister.MODEL_CHEMICALMIXERBASE);
        matrixStackIn.m_85836_();
        RenderingUtils.prepareRotationalTileModel((BlockEntity)tileEntityIn, (PoseStack)matrixStackIn);
        matrixStackIn.m_85837_(0.0, 0.0625, 0.0);
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)tileEntityIn, (RenderType)RenderType.m_110451_(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        ibakedmodel = this.getModel(ElectrodynamicsClientRegister.MODEL_CHEMICALMIXERBLADES);
        matrixStackIn.m_85837_(0.5, 0.4375, 0.5);
        ComponentProcessor proc = (ComponentProcessor)tileEntityIn.getComponent(IComponentType.Processor);
        float degrees = 0.0f;
        if (proc.isActive(0)) {
            degrees = ((Double[])proc.operatingTicks.getValue())[0].floatValue() / Math.max(((Double[])proc.requiredTicks.getValue())[0].floatValue(), 1.0f) * 360.0f * ((Double)proc.operatingSpeed.getValue()).floatValue() * 2.0f;
        }
        matrixStackIn.m_252781_(MathUtils.rotQuaternionDeg((float)0.0f, (float)degrees, (float)0.0f));
        RenderingUtils.renderModel((BakedModel)ibakedmodel, (BlockEntity)tileEntityIn, (RenderType)RenderType.m_110451_(), (PoseStack)matrixStackIn, (MultiBufferSource)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)tileEntityIn.getComponent(IComponentType.FluidHandler);
        FluidStack fluid = null;
        for (PropertyFluidTank tank : multi.getInputTanks()) {
            if (tank.isEmpty()) continue;
            fluid = tank.getFluid();
            break;
        }
        if (fluid == null) {
            for (PropertyFluidTank tank : multi.getOutputTanks()) {
                if (tank.isEmpty()) continue;
                fluid = tank.getFluid();
                break;
            }
        }
        if (fluid != null) {
            AABB box = new AABB(0.125, 0.4375, 0.125, 0.875, 0.625, 0.875);
            VertexConsumer builder = bufferIn.m_6299_(Sheets.m_110792_());
            RenderingUtils.renderFluidBox((PoseStack)matrixStackIn, (Minecraft)Minecraft.m_91087_(), (VertexConsumer)builder, (AABB)box, (FluidStack)fluid, (int)combinedLightIn, (int)combinedOverlayIn, (boolean[])RenderingUtils.ALL_FACES);
        }
        matrixStackIn.m_85849_();
    }
}

