/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import electrodynamics.common.tile.machines.quarry.TileQuarry;
import electrodynamics.common.tile.machines.quarry.TileSeismicRelay;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import voltaic.client.VoltaicClientRegister;
import voltaic.client.render.AbstractTileRenderer;
import voltaic.prefab.utilities.RenderingUtils;

public class RenderSeismicRelay
extends AbstractTileRenderer<TileSeismicRelay> {
    private static final AABB LEFT = new AABB(0.1875, 0.9375, 0.1875, 0.8125, (double)0.98f, 0.3125);
    private static final AABB UP = new AABB(0.1875, 0.9375, 0.3125, 0.3125, (double)0.98f, 0.6875);
    private static final AABB RIGHT = new AABB(0.1875, 0.9375, 0.6875, 0.8125, (double)0.98f, 0.8125);
    private static final AABB DOWN = new AABB(0.6875, 0.9375, 0.3125, 0.8125, (double)0.98f, 0.6875);

    public RenderSeismicRelay(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TileSeismicRelay tile, float tick, @NotNull PoseStack stack, @NotNull MultiBufferSource source, int light, int overlay) {
        if (((List)tile.markerLocs.getValue()).size() > 3) {
            TileQuarry quarry;
            Minecraft minecraft = Minecraft.m_91087_();
            VertexConsumer sheetBuilder = source.m_6299_(RenderingUtils.beaconType());
            RenderingUtils.renderSolidColorBox((PoseStack)stack, (Minecraft)minecraft, (VertexConsumer)sheetBuilder, (AABB)LEFT, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (int)255, (int)0, (boolean[])RenderingUtils.ALL_FACES);
            RenderingUtils.renderSolidColorBox((PoseStack)stack, (Minecraft)minecraft, (VertexConsumer)sheetBuilder, (AABB)UP, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (int)255, (int)0, (boolean[])RenderingUtils.ALL_FACES);
            RenderingUtils.renderSolidColorBox((PoseStack)stack, (Minecraft)minecraft, (VertexConsumer)sheetBuilder, (AABB)RIGHT, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (int)255, (int)0, (boolean[])RenderingUtils.ALL_FACES);
            RenderingUtils.renderSolidColorBox((PoseStack)stack, (Minecraft)minecraft, (VertexConsumer)sheetBuilder, (AABB)DOWN, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (int)255, (int)0, (boolean[])RenderingUtils.ALL_FACES);
            Direction facing = tile.getFacing().m_122424_();
            boolean doesQuarryHaveRing = false;
            BlockEntity entity = this.level().m_7702_(tile.m_58899_().m_121945_(facing.m_122427_()));
            if (entity instanceof TileQuarry) {
                quarry = (TileQuarry)entity;
                doesQuarryHaveRing = (Boolean)quarry.hasRing.getValue();
            }
            if ((entity = this.level().m_7702_(tile.m_58899_().m_121945_(facing.m_122428_()))) instanceof TileQuarry) {
                quarry = (TileQuarry)entity;
                doesQuarryHaveRing = (Boolean)quarry.hasRing.getValue();
            }
            if (!doesQuarryHaveRing) {
                return;
            }
            AABB beam = facing == Direction.NORTH ? new AABB(0.4375, 0.5625, 0.0, 0.5625, 0.6875, -0.375) : (facing == Direction.SOUTH ? new AABB(0.4375, 0.5625, 1.0, 0.5625, 0.6875, 1.375) : (facing == Direction.EAST ? new AABB(1.0, 0.5625, 0.4375, 1.375, 0.6875, 0.5625) : new AABB(0.0, 0.5625, 0.4375, -0.375, 0.6875, 0.5625)));
            int time = 200;
            int cutoff = 180;
            int half = (time - cutoff) / 2;
            float alpha = this.getGameTime() % (long)time;
            if (alpha < (float)cutoff) {
                return;
            }
            if ((alpha = (float)time - alpha) <= (float)half) {
                alpha /= (float)half;
            } else {
                alpha -= (float)half;
                alpha = 1.0f - alpha / (float)half;
            }
            TextureAtlasSprite whiteTexture = VoltaicClientRegister.whiteSprite();
            RenderingUtils.renderFilledBoxNoOverlay((PoseStack)stack, (VertexConsumer)sheetBuilder, (AABB)beam, (float)1.0f, (float)0.0f, (float)0.0f, (float)alpha, (float)whiteTexture.m_118409_(), (float)whiteTexture.m_118411_(), (float)whiteTexture.m_118412_(), (float)whiteTexture.m_118412_(), (int)255, (boolean[])RenderingUtils.ALL_FACES);
        }
    }
}

