/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.client.screen.tile;

import electrodynamics.common.inventory.container.tile.ContainerPotentiometer;
import electrodynamics.common.tile.electricitygrid.TilePotentiometer;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.editbox.ScreenComponentEditBox;
import voltaic.prefab.screen.component.types.ScreenComponentSimpleLabel;
import voltaic.prefab.screen.component.utils.AbstractScreenComponent;
import voltaic.prefab.utilities.math.Color;

public class ScreenPotentiometer
extends GenericScreen<ContainerPotentiometer> {
    private ScreenComponentEditBox consumption = new ScreenComponentEditBox(72, 35, 80, 16, this.getFontRenderer()).setTextColor(Color.WHITE).setTextColorUneditable(Color.WHITE).setMaxLength(30).setFilter(ScreenComponentEditBox.DECIMAL).setResponder(this::setConsumption);
    private boolean needsUpdate = true;

    public ScreenPotentiometer(ContainerPotentiometer container, Inventory inv, Component title) {
        super((GenericContainer)container, inv, title);
        this.addEditBox(this.consumption);
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(10, 39, 10, Color.TEXT_GRAY, (Component)ElectroTextUtils.gui("potentiometer.usage", new Object[0])));
        this.addComponent((AbstractScreenComponent)new ScreenComponentSimpleLabel(155, 39, 10, Color.TEXT_GRAY, DisplayUnits.WATT.getSymbol()));
    }

    private void setConsumption(String value) {
        if (value.isEmpty()) {
            return;
        }
        TilePotentiometer potentiometer = (TilePotentiometer)((ContainerPotentiometer)this.f_97732_).getSafeHost();
        if (potentiometer == null) {
            return;
        }
        double consumption = 0.0;
        try {
            consumption = Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        potentiometer.powerConsumption.setValue((Object)consumption);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.needsUpdate) {
            this.needsUpdate = false;
            TilePotentiometer source = (TilePotentiometer)((ContainerPotentiometer)this.f_97732_).getSafeHost();
            if (source != null) {
                this.consumption.setValue("" + source.powerConsumption.getValue());
            }
        }
    }
}

