/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.armor.types;

import electrodynamics.client.ElectrodynamicsClientRegister;
import electrodynamics.client.keys.KeyBinds;
import electrodynamics.client.model.armor.ModelJetpack;
import electrodynamics.common.item.gear.armor.ICustomArmor;
import electrodynamics.common.packet.NetworkHandler;
import electrodynamics.common.packet.types.client.PacketRenderJetpackParticles;
import electrodynamics.common.packet.types.server.PacketJetpackFlightServer;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsCreativeTabs;
import electrodynamics.registers.ElectrodynamicsGases;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.network.PacketDistributor;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasHandlerItemStack;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.common.item.gear.ItemVoltaicArmor;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.registers.VoltaicCapabilities;

public class ItemJetpack
extends ItemVoltaicArmor {
    public static final int MAX_CAPACITY = 30000;
    public static final int USAGE_PER_TICK = 1;
    public static final double VERT_SPEED_INCREASE = 0.5;
    public static final double TERMINAL_VERTICAL_VELOCITY = 1.0;
    public static final int MAX_PRESSURE = 4;
    public static final int MAX_TEMPERATURE = 293;
    private static final String ARMOR_TEXTURE_LOCATION = "electrodynamics:textures/model/armor/jetpack.png";
    public static final float OFFSET = 0.1f;
    public static final String DELTA_Y_KEY = "prevdeltay";
    public static final String WAS_HURT_KEY = "washurt";

    public ItemJetpack() {
        super((ArmorMaterial)Jetpack.JETPACK, ArmorItem.Type.CHESTPLATE, new Item.Properties().m_41487_(1), () -> (CreativeModeTab)ElectrodynamicsCreativeTabs.MAIN.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> properties) {
                ModelJetpack model = new ModelJetpack(ElectrodynamicsClientRegister.JETPACK.m_171564_());
                model.f_102817_ = properties.f_102817_;
                model.f_102609_ = properties.f_102609_;
                model.f_102610_ = properties.f_102610_;
                return model;
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new GasHandlerItemStack(stack, 30000, 293, 4).setPredicate(ItemJetpack.getGasValidator());
    }

    public void addCreativeModeItems(CreativeModeTab tab, List<ItemStack> items) {
        super.addCreativeModeItems(tab, items);
        if (VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM != null) {
            ItemStack full = new ItemStack((ItemLike)this);
            GasStack gas = new GasStack((Gas)ElectrodynamicsGases.HYDROGEN.get(), 30000, 293, 1);
            full.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> cap.fill(gas, GasAction.EXECUTE));
            items.add(full);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        ItemJetpack.staticAppendHoverText(stack, world, tooltip, flagIn);
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public static void staticAppendHoverText(ItemStack stack, Level world, List<Component> tooltips, TooltipFlag flagIn) {
        if (VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM != null) {
            stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> {
                GasStack gas = cap.getGasInTank(0);
                if (gas.isEmpty()) {
                    tooltips.add((Component)VoltaicTextUtils.ratio((Component)Component.m_237113_((String)"0"), (Component)ChatFormatter.formatFluidMilibuckets((double)30000.0)).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltips.add((Component)VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)gas.getAmount()), (Component)ChatFormatter.formatFluidMilibuckets((double)30000.0)).m_130940_(ChatFormatting.GRAY));
                    tooltips.add((Component)ChatFormatter.getChatDisplayShort((double)gas.getTemperature(), (IDisplayUnit)DisplayUnits.TEMPERATURE_KELVIN).m_130940_(ChatFormatting.GRAY));
                    tooltips.add((Component)ChatFormatter.getChatDisplayShort((double)gas.getPressure(), (IDisplayUnit)DisplayUnits.PRESSURE_ATM).m_130940_(ChatFormatting.GRAY));
                }
            });
            if (Screen.m_96638_()) {
                tooltips.add((Component)ElectroTextUtils.tooltip("maxpressure", ChatFormatter.getChatDisplayShort((double)4.0, (IDisplayUnit)DisplayUnits.PRESSURE_ATM)).m_130940_(ChatFormatting.GRAY));
                tooltips.add((Component)ElectroTextUtils.tooltip("maxtemperature", ChatFormatter.getChatDisplayShort((double)293.0, (IDisplayUnit)DisplayUnits.TEMPERATURE_KELVIN)).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (stack.m_41782_()) {
            tooltips.add(ItemJetpack.getModeText(stack.m_41783_().m_128451_("mode")));
        } else {
            tooltips.add((Component)ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("jetpack.moderegular", new Object[0]).m_130940_(ChatFormatting.GREEN)));
        }
    }

    public static Component getModeText(int mode) {
        return switch (mode) {
            case 0 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("jetpack.moderegular", new Object[0]).m_130940_(ChatFormatting.GREEN));
            case 1 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("jetpack.modehover", new Object[0]).m_130940_(ChatFormatting.AQUA));
            case 2 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("jetpack.modeelytra", new Object[0]).m_130940_(ChatFormatting.YELLOW));
            case 3 -> ElectroTextUtils.tooltip("jetpack.mode", new Object[0]).m_130940_(ChatFormatting.GRAY).m_7220_((Component)ElectroTextUtils.tooltip("jetpack.modeoff", new Object[0]).m_130940_(ChatFormatting.RED));
            default -> Component.m_237119_();
        };
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        super.onArmorTick(stack, world, player);
        ItemJetpack.armorTick(stack, world, player, 0.1f, false);
    }

    public static void armorTick(ItemStack stack, Level world, Player player, float particleZ, boolean isCombat) {
        if (world.f_46443_) {
            ArmorItem item = (ArmorItem)stack.m_41720_();
            if (item.m_40402_() == EquipmentSlot.CHEST && stack.m_41782_()) {
                boolean isDown = KeyBinds.jetpackAscend.m_90857_();
                int mode = stack.m_41782_() ? stack.m_41783_().m_128451_("mode") : 0;
                boolean enoughFuel = stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).map(cap -> cap.getGasInTank(0).getAmount() >= 1).orElse(false);
                if (enoughFuel) {
                    IGasHandlerItem handler = (IGasHandlerItem)stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).cast().resolve().get();
                    int pressure = handler.getGasInTank(0).getPressure();
                    if (mode == 0 && isDown) {
                        double deltaY = ItemJetpack.moveWithJetpack(0.5, 1.0 * (double)pressure, player, stack);
                        ItemJetpack.renderClientParticles(world, player, particleZ);
                        ItemJetpack.sendPacket(player, true, deltaY);
                    } else if (mode == 1 && isDown) {
                        double deltaY = ItemJetpack.moveWithJetpack(0.25 * (double)pressure, 0.5 * (double)pressure, player, stack);
                        ItemJetpack.renderClientParticles(world, player, particleZ);
                        ItemJetpack.sendPacket(player, true, deltaY);
                    } else if (mode == 1 && player.m_146900_().m_60795_()) {
                        double deltaY = ItemJetpack.hoverWithJetpack(pressure, player, stack);
                        ItemJetpack.renderClientParticles(world, player, particleZ);
                        ItemJetpack.sendPacket(player, true, deltaY);
                    } else if (mode == 2 && isDown) {
                        double deltaY = ItemJetpack.moveWithJetpack(0.125 * (double)pressure, 0.25 * (double)pressure, player, stack);
                        ItemJetpack.sendPacket(player, true, deltaY);
                    } else {
                        ItemJetpack.sendPacket(player, false, player.m_20184_().f_82480_);
                    }
                } else {
                    ItemJetpack.sendPacket(player, false, player.m_20184_().f_82480_);
                }
            } else {
                ItemJetpack.sendPacket(player, false, player.m_20184_().f_82480_);
            }
        } else {
            CompoundTag tag = stack.m_41784_();
            boolean hasRan = tag.m_128471_("used");
            tag.m_128379_("false", tag.m_128471_("false"));
            if (hasRan) {
                ItemJetpack.drainHydrogen(stack);
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PacketRenderJetpackParticles(player.m_20148_(), isCombat));
                player.m_183634_();
            }
        }
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack stack1, ItemStack stack2) {
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return ItemJetpack.staticIsBarVisible(stack);
    }

    public static boolean staticIsBarVisible(ItemStack stack) {
        return stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).map(cap -> 13.0 * (double)cap.getGasInTank(0).getAmount() / (double)cap.getTankCapacity(0) < 13.0).orElse(false);
    }

    public int m_142158_(ItemStack stack) {
        return ItemJetpack.staticGetBarWidth(stack);
    }

    public static int staticGetBarWidth(ItemStack stack) {
        return (int)Math.round(stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).map(cap -> 13.0 * (double)cap.getGasInTank(0).getAmount() / (double)cap.getTankCapacity(0)).orElse(13.0));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public static Predicate<GasStack> getGasValidator() {
        return gas -> gas.getGas().equals(ElectrodynamicsGases.HYDROGEN.get());
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ItemJetpack.staticCanElytraFly(stack, entity);
    }

    public static boolean staticCanElytraFly(ItemStack stack, LivingEntity entity) {
        int mode = stack.m_41782_() ? stack.m_41783_().m_128451_("mode") : 0;
        return mode == 2 && stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).map(cap -> cap.getGasInTank(0).getAmount() >= 1).orElse(false) != false;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        return ItemJetpack.staticElytraFlightTick(stack, entity, flightTicks);
    }

    public static boolean staticElytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (entity.m_9236_().f_46443_) {
            return true;
        }
        int nextFlightTick = flightTicks + 1;
        if (nextFlightTick % 10 == 0) {
            if (nextFlightTick % 20 == 0) {
                ItemJetpack.drainHydrogen(stack);
            }
            entity.m_146850_(GameEvent.f_223705_);
        }
        return true;
    }

    protected static double moveWithJetpack(double speed, double termVelocity, Player player, ItemStack jetpack) {
        Vec3 movement = player.m_20184_();
        double newY = Math.min(movement.f_82480_ + speed, termVelocity);
        Vec3 currMovement = new Vec3(movement.f_82479_, newY, movement.f_82481_);
        player.m_20256_(currMovement);
        player.m_183634_();
        return currMovement.f_82480_;
    }

    protected static double hoverWithJetpack(double multiplier, Player player, ItemStack jetpack) {
        Vec3 movement = player.m_20184_();
        if (player.f_19812_ && ItemJetpack.wasEntityHurt(jetpack)) {
            movement = new Vec3(movement.f_82479_, ItemJetpack.getPrevDeltaY(jetpack), movement.f_82481_);
        }
        movement = player.m_6144_() ? new Vec3(movement.f_82479_, -0.3 * multiplier, movement.f_82481_) : new Vec3(movement.f_82479_, 0.0, movement.f_82481_);
        player.m_20256_(movement);
        player.m_183634_();
        return movement.f_82480_;
    }

    public static void renderClientParticles(Level world, Player player, float particleZ) {
        int i;
        Vec3 worldPosition = player.m_20182_();
        float rad = (float)((double)(ItemJetpack.processDeg(player.f_20883_) / 180.0f) * Math.PI);
        double cosY = Mth.m_14089_((float)rad);
        double sinY = Mth.m_14031_((float)rad);
        double xOffCos = cosY * 0.2;
        double xOffSin = sinY * 0.2;
        double zOffCos = cosY * (double)particleZ;
        double zOffSin = sinY * (double)particleZ;
        double xRight = worldPosition.f_82479_ - xOffCos + zOffSin;
        double xLeft = worldPosition.f_82479_ + xOffCos + zOffSin;
        double zRight = worldPosition.f_82481_ - zOffCos - xOffSin;
        double zLeft = worldPosition.f_82481_ - zOffCos + xOffSin;
        double y = worldPosition.f_82480_ + (player.m_6144_() ? 0.5 : 0.8);
        for (i = 0; i < 10; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xRight, y, zRight, 0.0, -2.0, 0.0);
        }
        for (i = 0; i < 10; ++i) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xLeft, y, zLeft, 0.0, -2.0, 0.0);
        }
    }

    protected static void drainHydrogen(ItemStack stack) {
        stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> cap.drain(1, GasAction.EXECUTE));
    }

    protected static void sendPacket(Player player, boolean state, double prevDeltaMove) {
        NetworkHandler.CHANNEL.sendToServer((Object)new PacketJetpackFlightServer(player.m_20148_(), state, prevDeltaMove));
    }

    protected static double getPrevDeltaY(ItemStack stack) {
        return stack.m_41784_().m_128459_(DELTA_Y_KEY);
    }

    protected static boolean wasEntityHurt(ItemStack stack) {
        return stack.m_41784_().m_128471_(WAS_HURT_KEY);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return ARMOR_TEXTURE_LOCATION;
    }

    private static float processDeg(float deg) {
        if (deg > 180.0f) {
            return deg - 360.0f;
        }
        if (deg < 180.0f) {
            return deg + 360.0f;
        }
        return deg;
    }

    public static enum Jetpack implements ICustomArmor
    {
        JETPACK;


        public SoundEvent m_7344_() {
            return SoundEvents.f_11677_;
        }

        public String m_6082_() {
            return "electrodynamics:jetpack";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }

        public int m_266425_(ArmorItem.Type pType) {
            return 100;
        }

        public int m_7366_(ArmorItem.Type pType) {
            return 1;
        }
    }
}

