/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools;

import electrodynamics.prefab.utilities.ElectroTextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasHandlerItemStack;
import voltaic.api.gas.GasStack;
import voltaic.api.inventory.InventoryTickConsumer;
import voltaic.common.item.ItemVoltaic;
import voltaic.prefab.utilities.VoltaicTextUtils;
import voltaic.registers.VoltaicCapabilities;
import voltaic.registers.VoltaicRegistries;

public class ItemPortableCylinder
extends ItemVoltaic {
    public static final int MAX_GAS_CAPCITY = 5000;
    public static final int MAX_TEMPERATURE = 1000;
    public static final int MAX_PRESSURE = 1000;
    public static final List<InventoryTickConsumer> INVENTORY_TICK_CONSUMERS = new ArrayList<InventoryTickConsumer>();

    public ItemPortableCylinder(Item.Properties properties, Supplier<CreativeModeTab> creativeTab) {
        super(properties, creativeTab);
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        items.add(new ItemStack((ItemLike)this));
        if (VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM != null) {
            for (Gas gas : VoltaicRegistries.gasRegistry().getValues()) {
                if (gas.isEmpty()) continue;
                ItemStack temp = new ItemStack((ItemLike)this);
                temp.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> ((GasHandlerItemStack)cap).setGas(new GasStack(gas, 5000, gas.getCondensationTemp() >= 293 ? gas.getCondensationTemp() + 1 : 293, 1)));
                items.add(temp);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        super.m_6883_(stack, level, entity, slot, isSelected);
        INVENTORY_TICK_CONSUMERS.forEach(consumer -> consumer.apply(stack, level, entity, Integer.valueOf(slot), Boolean.valueOf(isSelected)));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new GasHandlerItemStack(stack, 5000, 1000, 1000);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltips, TooltipFlag isAdvanced) {
        stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).ifPresent(cap -> {
            GasStack gas = cap.getGasInTank(0);
            if (gas.isEmpty()) {
                tooltips.add((Component)VoltaicTextUtils.ratio((Component)Component.m_237113_((String)"0"), (Component)ChatFormatter.formatFluidMilibuckets((double)5000.0)).m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                tooltips.add((Component)gas.getGas().getDescription().m_6881_().m_130940_(ChatFormatting.GRAY));
                tooltips.add((Component)VoltaicTextUtils.ratio((Component)ChatFormatter.formatFluidMilibuckets((double)gas.getAmount()), (Component)ChatFormatter.formatFluidMilibuckets((double)5000.0)).m_130940_(ChatFormatting.DARK_GRAY));
                tooltips.add((Component)ChatFormatter.getChatDisplayShort((double)gas.getTemperature(), (IDisplayUnit)DisplayUnits.TEMPERATURE_KELVIN).m_130940_(ChatFormatting.DARK_GRAY));
                tooltips.add((Component)ChatFormatter.getChatDisplayShort((double)gas.getPressure(), (IDisplayUnit)DisplayUnits.PRESSURE_ATM).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (Screen.m_96638_()) {
                tooltips.add((Component)ElectroTextUtils.tooltip("maxpressure", ChatFormatter.getChatDisplayShort((double)1000.0, (IDisplayUnit)DisplayUnits.PRESSURE_ATM)).m_130940_(ChatFormatting.GRAY));
                tooltips.add((Component)ElectroTextUtils.tooltip("maxtemperature", ChatFormatter.getChatDisplayShort((double)1000.0, (IDisplayUnit)DisplayUnits.TEMPERATURE_KELVIN)).m_130940_(ChatFormatting.GRAY));
            }
        });
        super.m_7373_(stack, level, tooltips, isAdvanced);
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).map(cap -> 13.0 * (double)cap.getGasInTank(0).getAmount() / (double)cap.getTankCapacity(0)).orElse(13.0));
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).map(cap -> 13.0 * (double)cap.getGasInTank(0).getAmount() / (double)cap.getTankCapacity(0) < 13.0).orElse(false);
    }
}

