/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.item.gear.tools.electric;

import electrodynamics.common.item.gear.tools.electric.utils.ElectricItemTier;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import voltaic.api.creativetab.CreativeTabSupplier;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.item.IItemElectric;
import voltaic.prefab.item.ElectricItemProperties;
import voltaic.prefab.utilities.VoltaicTextUtils;

public class ItemElectricChainsaw
extends DiggerItem
implements IItemElectric,
CreativeTabSupplier {
    private final ElectricItemProperties properties;
    private final Supplier<CreativeModeTab> creativeTab;

    public ItemElectricChainsaw(ElectricItemProperties properties, Supplier<CreativeModeTab> creativeTab) {
        super(4.0f, -2.4f, (Tier)ElectricItemTier.DRILL, BlockTags.f_144280_, properties.m_41503_(0));
        this.properties = properties;
        this.creativeTab = creativeTab;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_150930_(newStack.m_41720_());
    }

    public void addCreativeModeItems(CreativeModeTab group, List<ItemStack> items) {
        ItemStack empty = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)empty, (double)0.0);
        items.add(empty);
        ItemStack charged = new ItemStack((ItemLike)this);
        IItemElectric.setEnergyStored((ItemStack)charged, (double)this.getMaximumCapacity(charged));
        items.add(charged);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.getJoulesStored(stack) > this.properties.extract.getJoules() ? super.m_8102_(stack, state) : 0.0f;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        this.extractPower(stack, this.properties.extract.getJoules(), false);
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.round(13.0 * this.getJoulesStored(stack) / this.getMaximumCapacity(stack));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getJoulesStored(stack) < this.getMaximumCapacity(stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.info", VoltaicTextUtils.ratio((Component)ChatFormatter.getChatDisplayShort((double)this.getJoulesStored(stack), (IDisplayUnit)DisplayUnits.JOULES), (Component)ChatFormatter.getChatDisplayShort((double)this.getMaximumCapacity(stack), (IDisplayUnit)DisplayUnits.JOULES)).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)ElectroTextUtils.tooltip("item.electric.voltage", ChatFormatter.getChatDisplayShort((double)this.properties.receive.getVoltage(), (IDisplayUnit)DisplayUnits.VOLTAGE).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        IItemElectric.addBatteryTooltip((ItemStack)stack, (Level)worldIn, tooltip);
    }

    public ElectricItemProperties getElectricProperties() {
        return this.properties;
    }

    public Item getDefaultStorageBattery() {
        return (Item)ElectrodynamicsItems.ITEM_BATTERY.get();
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!IItemElectric.overrideOtherStackedOnMe((ItemStack)stack, (ItemStack)other, (Slot)slot, (ClickAction)action, (Player)player, (SlotAccess)access)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        return true;
    }

    public boolean isAllowedInCreativeTab(CreativeModeTab tab) {
        return this.creativeTab.get() == tab;
    }

    public boolean hasCreativeTab() {
        return this.creativeTab != null;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return this.getJoulesStored(stack) > this.properties.extract.getJoules() ? ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) || ToolActions.DEFAULT_SHEARS_ACTIONS.contains(toolAction) : false;
    }
}

