/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.packet.types.client;

import electrodynamics.client.event.levelstage.HandlerSeismicScanner;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketAddClientRenderInfo {
    private final UUID playerId;
    private final BlockPos pos;

    public PacketAddClientRenderInfo(UUID uuid, BlockPos pos) {
        this.playerId = uuid;
        this.pos = pos;
    }

    public static void handle(PacketAddClientRenderInfo message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel world = minecraft.f_91073_;
            if (world != null && minecraft.f_91074_ != null && minecraft.f_91074_.m_20148_().equals(message.playerId)) {
                HandlerSeismicScanner.addBlock(message.pos);
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketAddClientRenderInfo message, FriendlyByteBuf buf) {
        buf.m_130077_(message.playerId);
        buf.writeInt(message.pos.m_123341_());
        buf.writeInt(message.pos.m_123342_());
        buf.writeInt(message.pos.m_123343_());
    }

    public static PacketAddClientRenderInfo decode(FriendlyByteBuf buf) {
        return new PacketAddClientRenderInfo(buf.m_130259_(), new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
    }
}

