/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;

public class TileCurrentRegulator
extends GenericTile {
    private boolean isLocked = false;
    public static final BlockEntityUtils.MachineDirection OUTPUT = BlockEntityUtils.MachineDirection.FRONT;
    public static final BlockEntityUtils.MachineDirection INPUT = BlockEntityUtils.MachineDirection.BACK;

    public TileCurrentRegulator(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CURRENTREGULATOR.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, true).receivePower(this::receivePower).getConnectedLoad(this::getConnectedLoad).setOutputDirections(new BlockEntityUtils.MachineDirection[]{OUTPUT}).setInputDirections(new BlockEntityUtils.MachineDirection[]{INPUT}).voltage(-1.0).getAmpacity(this::getAmpacity).getMinimumVoltage(this::getMinimumVoltage));
    }

    public TransferPack receivePower(TransferPack transfer, boolean debug) {
        if (this.isLocked) {
            return TransferPack.EMPTY;
        }
        Direction output = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)TileCurrentRegulator.OUTPUT.mappedDir);
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(output));
        if (tile == null) {
            return TransferPack.EMPTY;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, output.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return TransferPack.EMPTY;
        }
        TransferPack accepted = electro.receivePower(TransferPack.joulesVoltage((double)(transfer.getJoules() * (double)ElectroConstants.CURRENTREGULATOR_EFFICIENCY), (double)transfer.getVoltage()), debug);
        this.isLocked = false;
        TransferPack adjusted = TransferPack.joulesVoltage((double)(accepted.getJoules() / (double)ElectroConstants.CURRENTREGULATOR_EFFICIENCY), (double)accepted.getVoltage());
        double ampacityInTicks = electro.getAmpacity();
        if (ampacityInTicks < 0.0) {
            return adjusted;
        }
        double currentInTicks = adjusted.getAmpsInTicks();
        if (currentInTicks > ampacityInTicks) {
            adjusted = TransferPack.ampsVoltage((double)ampacityInTicks, (double)adjusted.getVoltage());
        }
        return adjusted;
    }

    public TransferPack getConnectedLoad(ICapabilityElectrodynamic.LoadProfile lastEnergy, Direction dir) {
        if (this.isLocked) {
            return TransferPack.EMPTY;
        }
        Direction output = BlockEntityUtils.getRelativeSide((Direction)this.getFacing(), (Direction)TileCurrentRegulator.OUTPUT.mappedDir);
        if (dir != output.m_122424_()) {
            return TransferPack.EMPTY;
        }
        BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_121945_(output));
        if (tile == null) {
            return TransferPack.EMPTY;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, output.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return TransferPack.EMPTY;
        }
        ICapabilityElectrodynamic.LoadProfile transformed = new ICapabilityElectrodynamic.LoadProfile(TransferPack.joulesVoltage((double)(lastEnergy.lastUsage().getJoules() * (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)lastEnergy.lastUsage().getVoltage()), TransferPack.joulesVoltage((double)(lastEnergy.maximumAvailable().getJoules() * (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)lastEnergy.maximumAvailable().getVoltage()));
        TransferPack returner = electro.getConnectedLoad(transformed, dir);
        this.isLocked = false;
        TransferPack adjusted = TransferPack.joulesVoltage((double)(returner.getJoules() / (double)ElectroConstants.CIRCUITBREAKER_EFFICIENCY), (double)returner.getVoltage());
        double ampacityInTicks = electro.getAmpacity();
        if (ampacityInTicks < 0.0) {
            return adjusted;
        }
        double currentInTicks = adjusted.getAmpsInTicks();
        if (currentInTicks > ampacityInTicks) {
            adjusted = TransferPack.ampsVoltage((double)ampacityInTicks, (double)adjusted.getVoltage());
        }
        return adjusted;
    }

    public double getMinimumVoltage() {
        Direction facing = this.getFacing();
        if (this.isLocked) {
            return 0.0;
        }
        BlockEntity output = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (output == null) {
            return -1.0;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)output.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, facing.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return -1.0;
        }
        double minimumVoltage = electro.getMinimumVoltage();
        this.isLocked = false;
        return minimumVoltage;
    }

    public double getAmpacity() {
        Direction facing = this.getFacing();
        if (this.isLocked) {
            return 0.0;
        }
        BlockEntity output = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (output == null) {
            return -1.0;
        }
        this.isLocked = true;
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)output.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, facing.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro == CapabilityUtils.EMPTY_ELECTRO) {
            this.isLocked = false;
            return -1.0;
        }
        double ampacity = electro.getAmpacity();
        this.isLocked = false;
        return ampacity;
    }
}

