/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerElectrolyticSeparator;
import electrodynamics.registers.ElectrodynamicsRecipies;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.gas.GasTank;
import voltaic.common.network.utils.GasUtilities;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericGasTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileElectrolyticSeparator
extends GenericGasTile
implements ITickableSound {
    public static final int MAX_INPUT_TANK_CAPACITY = 5000;
    public static final int MAX_OUTPUT_TANK_CAPACITY = 5000;
    public long clientTicks = 0L;
    private static final BlockEntityUtils.MachineDirection OXYGEN_DIRECTION = BlockEntityUtils.MachineDirection.RIGHT;
    private static final BlockEntityUtils.MachineDirection HYDROGEN_DIRECTION = BlockEntityUtils.MachineDirection.LEFT;
    private boolean isSoundPlaying = false;

    public TileElectrolyticSeparator(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_ELECTROLYTICSEPARATOR.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT}).voltage(240.0));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).setInputTanks(1, TileElectrolyticSeparator.arr((int[])new int[]{5000})).setRecipeType((RecipeType)ElectrodynamicsRecipies.ELECTROLYTIC_SEPERATOR_TYPE.get()));
        this.addComponent((IComponent)new ComponentGasHandlerMulti((GenericTile)this).setOutputDirections(new BlockEntityUtils.MachineDirection[]{OXYGEN_DIRECTION, HYDROGEN_DIRECTION}).setOutputTanks(2, TileElectrolyticSeparator.arr((int[])new int[]{5000, 5000}), TileElectrolyticSeparator.arr((int[])new int[]{1000, 1000}), TileElectrolyticSeparator.arr((int[])new int[]{1024, 1024})).setRecipeType((RecipeType)ElectrodynamicsRecipies.ELECTROLYTIC_SEPERATOR_TYPE.get()).setCondensedHandler(this.getCondensedHandler()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().bucketInputs(1).gasOutputs(2).upgrades(3)).validUpgrades(ContainerElectrolyticSeparator.VALID_UPGRADES).valid(TileElectrolyticSeparator.machineValidator()));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess((component, procNumber) -> component.consumeBucket().dispenseGasCylinder().canProcessFluid2GasRecipe(procNumber.intValue(), (RecipeType)ElectrodynamicsRecipies.ELECTROLYTIC_SEPERATOR_TYPE.get())).process(ComponentProcessor::processFluid2GasRecipe));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.electrolyticseparator.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerElectrolyticSeparator((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentGasHandlerMulti handler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        GasUtilities.outputToPipe((GenericTile)this, (GasTank[])handler.getOutputTanks()[0].asArray(), (Direction[])new Direction[]{TileElectrolyticSeparator.OXYGEN_DIRECTION.mappedDir});
        GasUtilities.outputToPipe((GenericTile)this, (GasTank[])handler.getOutputTanks()[1].asArray(), (Direction[])new Direction[]{TileElectrolyticSeparator.HYDROGEN_DIRECTION.mappedDir});
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!this.shouldPlaySound()) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.15) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_() * 0.4 + 0.5, (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_ELECTROLYTICSEPARATOR.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0);
    }

    public int getComparatorSignal() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0) ? 15 : 0;
    }
}

