/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.fluid;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;

public class TileElectricPump
extends GenericTile
implements ITickableSound {
    private SingleProperty<Boolean> isGenerating = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "isGenerating", (Object)false));
    protected CachedTileOutput output;
    private boolean isSoundPlaying = false;

    public TileElectricPump(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_ELECTRICPUMP.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).maxJoules(ElectroConstants.ELECTRICPUMP_USAGE_PER_TICK * 20.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentFluidHandlerMulti((GenericTile)this).setOutputTanks(1, new int[]{0}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT}).setOutputFluidTags(new TagKey[]{FluidTags.f_13131_}));
    }

    protected void tickServer(ComponentTickable tickable) {
        ComponentElectrodynamic electro;
        Direction direction = this.getFacing().m_122427_();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(direction));
        }
        if ((electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getJoulesStored() < ElectroConstants.ELECTRICPUMP_USAGE_PER_TICK) {
            this.isGenerating.setValue((Object)false);
            return;
        }
        if (tickable.getTicks() % 10L == 0L) {
            this.output.update(this.f_58858_.m_121945_(direction));
            FluidState state = this.f_58857_.m_6425_(this.f_58858_.m_121945_(Direction.DOWN));
            this.isGenerating.setValue((Object)(state.m_76170_() && state.m_76152_() == Fluids.f_76193_ ? 1 : 0));
        }
        if (((Boolean)this.isGenerating.getValue()).booleanValue() && this.output.valid()) {
            electro.joules(electro.getJoulesStored() - ElectroConstants.ELECTRICPUMP_USAGE_PER_TICK);
            FluidUtilities.receiveFluid((BlockEntity)((BlockEntity)this.output.getSafe()), (Direction)direction.m_122424_(), (FluidStack)new FluidStack((Fluid)Fluids.f_76193_, 200), (boolean)false);
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!this.shouldPlaySound()) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.15) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() + this.f_58857_.f_46441_.m_188500_() * 0.2 + 0.8, (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, (double)this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188500_(), (double)this.f_58858_.m_123342_() - this.f_58857_.f_46441_.m_188500_() * 0.2 - 0.1, (double)this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_ELECTRICPUMP.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return (Boolean)this.isGenerating.getValue();
    }

    public int getComparatorSignal() {
        return (Boolean)this.isGenerating.getValue() != false ? 15 : 0;
    }
}

