/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer.thermoelectricmanipulator;

import electrodynamics.common.block.states.ElectrodynamicsBlockStates;
import electrodynamics.common.inventory.container.tile.ContainerThermoelectricManipulator;
import electrodynamics.common.tile.pipelines.gas.gastransformer.GenericTileGasTransformer;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.api.gas.PropertyGasTank;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.utils.IComponentFluidHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.registers.VoltaicGases;

public abstract class GenericTileThermoelectricManipulator
extends GenericTileGasTransformer {
    public final SingleProperty<Integer> targetTemperature = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "targettemperature", (Object)293));
    private boolean isFluid = false;
    private boolean changeState = false;
    private Gas evaporatedGas;

    public GenericTileThermoelectricManipulator(BlockEntityType<?> type, BlockPos worldPos, BlockState blockState) {
        super(type, worldPos, blockState);
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(this.getUsagePerTick() * 10.0));
        this.addComponent((IComponent)this.getFluidHandler());
    }

    @Override
    public boolean canProcess(ComponentProcessor processor, int procNumber) {
        Direction facing = this.getFacing();
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        processor.consumeGasCylinder();
        processor.dispenseGasCylinder();
        processor.consumeBucket();
        processor.dispenseBucket();
        this.outputToPipe(processor, gasHandler, facing);
        ManipulatorStatusCheckWrapper result = this.checkGasConditions(processor);
        if (result.canProcess()) {
            this.isFluid = false;
        } else {
            result = this.checkFluidConditions(processor);
            this.isFluid = result.canProcess();
        }
        this.changeState = result.changeState();
        boolean isHeating = result.status() == ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT && result.canProcess();
        this.updateLit(isHeating, facing);
        ElectrodynamicsBlockStates.ManipulatorHeatingStatus currStatus = (ElectrodynamicsBlockStates.ManipulatorHeatingStatus)((Object)this.m_58900_().m_61143_(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS));
        if (currStatus != result.status()) {
            this.m_58904_().m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS, (Comparable)((Object)result.status())));
        }
        return result.canProcess();
    }

    public abstract void outputToPipe(ComponentProcessor var1, ComponentGasHandlerMulti var2, Direction var3);

    public abstract void updateLit(boolean var1, Direction var2);

    private ManipulatorStatusCheckWrapper checkGasConditions(ComponentProcessor processor) {
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        PropertyGasTank inputTank = gasHandler.getInputTanks()[0];
        if (inputTank.isEmpty()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsagePerTick() * (Double)processor.operatingSpeed.getValue()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        if (inputTank.getGas().getGas().getCondensationTemp() >= (Integer)this.targetTemperature.getValue()) {
            ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
            PropertyFluidTank outputTank = fluidHandler.getOutputTanks()[0];
            if (outputTank.getFluidAmount() >= outputTank.getCapacity()) {
                return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
            }
            if (inputTank.getGas().getGas().noCondensedFluid()) {
                return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
            }
            Fluid condensedFluid = inputTank.getGas().getGas().getCondensedFluid();
            if (!outputTank.isEmpty() && !outputTank.getFluid().getFluid().m_6212_(condensedFluid)) {
                return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
            }
            ElectrodynamicsBlockStates.ManipulatorHeatingStatus status = inputTank.getGas().getTemperature() < (Integer)this.targetTemperature.getValue() ? ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT : (inputTank.getGas().getTemperature() > (Integer)this.targetTemperature.getValue() ? ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL : ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF);
            return new ManipulatorStatusCheckWrapper(true, status, true);
        }
        PropertyGasTank outputTank = gasHandler.getOutputTanks()[0];
        if (outputTank.getGasAmount() >= outputTank.getCapacity()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        if (!outputTank.isEmpty() && !outputTank.getGas().isSameGas(inputTank.getGas())) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        if (inputTank.getGas().getTemperature() <= 1) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        ElectrodynamicsBlockStates.ManipulatorHeatingStatus status = inputTank.getGas().getTemperature() < (Integer)this.targetTemperature.getValue() ? ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT : (inputTank.getGas().getTemperature() > (Integer)this.targetTemperature.getValue() ? ElectrodynamicsBlockStates.ManipulatorHeatingStatus.COOL : ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF);
        return new ManipulatorStatusCheckWrapper(true, status, false);
    }

    private ManipulatorStatusCheckWrapper checkFluidConditions(ComponentProcessor processor) {
        ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        PropertyFluidTank inputTank = fluidHandler.getInputTanks()[0];
        if (inputTank.isEmpty()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsagePerTick() * (Double)processor.operatingSpeed.getValue()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        PropertyGasTank outputTank = gasHandler.getOutputTanks()[0];
        if (outputTank.getGasAmount() >= outputTank.getCapacity()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        this.evaporatedGas = VoltaicGases.MAPPED_GASSES.getOrDefault(inputTank.getFluid().getFluid(), (Gas)VoltaicGases.EMPTY.get());
        if (this.evaporatedGas.isEmpty()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        if ((Integer)this.targetTemperature.getValue() <= this.evaporatedGas.getCondensationTemp()) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        if (!outputTank.isEmpty() && !outputTank.getGas().getGas().equals((Object)this.evaporatedGas)) {
            return new ManipulatorStatusCheckWrapper(false, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF, false);
        }
        return new ManipulatorStatusCheckWrapper(true, ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT, true);
    }

    @Override
    public void process(ComponentProcessor processor, int procNumber) {
        ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        int conversionRate = (int)((double)this.getConversionRate() * (Double)processor.operatingSpeed.getValue());
        if (this.isFluid && this.changeState) {
            PropertyFluidTank inputTank = fluidHandler.getInputTanks()[0];
            PropertyGasTank outputTank = gasHandler.getOutputTanks()[0];
            int deltaT = (Integer)this.targetTemperature.getValue() - this.evaporatedGas.getCondensationTemp();
            if ((conversionRate *= this.getAdjustedHeatingFactor(deltaT)) < 1) {
                conversionRate = 1;
            }
            int maxTake = Math.min(inputTank.getFluidAmount(), conversionRate);
            GasStack evaporatedPotential = new GasStack(this.evaporatedGas, maxTake, this.evaporatedGas.getCondensationTemp(), 1);
            evaporatedPotential.heat(deltaT);
            int taken = outputTank.fill(evaporatedPotential, GasAction.EXECUTE);
            if (taken == 0) {
                return;
            }
            evaporatedPotential.setAmount(taken);
            evaporatedPotential.heat(-deltaT);
            inputTank.drain(evaporatedPotential.getAmount(), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.changeState) {
            PropertyGasTank inputTank = gasHandler.getInputTanks()[0];
            PropertyFluidTank outputTank = fluidHandler.getOutputTanks()[0];
            int targetTemp = (Integer)this.targetTemperature.getValue() < inputTank.getGas().getGas().getCondensationTemp() ? inputTank.getGas().getGas().getCondensationTemp() : ((Integer)this.targetTemperature.getValue()).intValue();
            int deltaT = targetTemp - inputTank.getGas().getTemperature();
            if ((conversionRate *= this.getAdjustedHeatingFactor(deltaT)) < 1) {
                conversionRate = 1;
            }
            GasStack condensedPotential = new GasStack(inputTank.getGas().getGas(), inputTank.getGasAmount(), inputTank.getGas().getTemperature(), inputTank.getGas().getPressure());
            condensedPotential.bringPressureTo(1);
            condensedPotential.heat(deltaT);
            int fluidAmount = Math.min(conversionRate, condensedPotential.getAmount());
            if (fluidAmount == 0) {
                return;
            }
            FluidStack condensedFluid = new FluidStack(condensedPotential.getGas().getCondensedFluid(), fluidAmount);
            int taken = outputTank.fill(condensedFluid, IFluidHandler.FluidAction.EXECUTE);
            if (taken == 0) {
                return;
            }
            condensedPotential.setAmount(taken);
            condensedPotential.bringPressureTo(inputTank.getGas().getPressure());
            condensedPotential.heat(-deltaT);
            inputTank.drain(condensedPotential, GasAction.EXECUTE);
        } else {
            PropertyGasTank inputTank = gasHandler.getInputTanks()[0];
            PropertyGasTank outputTank = gasHandler.getOutputTanks()[0];
            int deltaT = (Integer)this.targetTemperature.getValue() - inputTank.getGas().getTemperature();
            int maxTake = inputTank.getGasAmount() > (conversionRate *= this.getAdjustedHeatingFactor(deltaT)) ? conversionRate : inputTank.getGasAmount();
            GasStack condensedPotential = new GasStack(inputTank.getGas().getGas(), maxTake, inputTank.getGas().getTemperature(), inputTank.getGas().getPressure());
            condensedPotential.heat(deltaT);
            int taken = outputTank.fill(condensedPotential, GasAction.EXECUTE);
            if (taken == 0) {
                return;
            }
            condensedPotential.setAmount(taken);
            condensedPotential.heat(-deltaT);
            inputTank.drain(condensedPotential, GasAction.EXECUTE);
        }
    }

    @Override
    public ComponentInventory getInventory() {
        return new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().bucketInputs(1).gasInputs(1).bucketOutputs(1).gasOutputs(1).upgrades(3)).valid(GenericTileThermoelectricManipulator.machineValidator()).validUpgrades(ContainerThermoelectricManipulator.VALID_UPGRADES);
    }

    public abstract IComponentFluidHandler getFluidHandler();

    public BiConsumer<GasTank, GenericTile> getCondensedHandler() {
        return (tank, tile) -> {
            PropertyFluidTank outputTank = ((ComponentFluidHandlerMulti)tile.getComponent(IComponentType.FluidHandler)).getOutputTanks()[0];
            GasStack tankGas = tank.getGas().copy();
            tank.setGas(GasStack.EMPTY);
            if (tankGas.isEmpty() || !outputTank.isEmpty()) {
                return;
            }
            Fluid fluid = tankGas.getGas().getCondensedFluid();
            if (fluid.m_6212_(Fluids.f_76191_)) {
                return;
            }
            tankGas.bringPressureTo(1);
            FluidStack fluidStack = new FluidStack(fluid, tankGas.getAmount());
            outputTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        };
    }

    private int getAdjustedHeatingFactor(int deltaT) {
        if (deltaT == 0) {
            return 1;
        }
        return (int)Math.max(1.0, Math.abs((double)this.getHeatTransfer() / (double)deltaT));
    }

    public abstract int getHeatTransfer();

    private record ManipulatorStatusCheckWrapper(boolean canProcess, ElectrodynamicsBlockStates.ManipulatorHeatingStatus status, boolean changeState) {
    }
}

