/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer.thermoelectricmanipulator;

import electrodynamics.common.block.states.ElectrodynamicsBlockStates;
import electrodynamics.common.inventory.container.tile.ContainerThermoelectricManipulator;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.gas.gastransformer.IMultiblockGasTransformer;
import electrodynamics.common.tile.pipelines.gas.gastransformer.TileGasTransformerSideBlock;
import electrodynamics.common.tile.pipelines.gas.gastransformer.thermoelectricmanipulator.GenericTileThermoelectricManipulator;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import voltaic.Voltaic;
import voltaic.api.fluid.PropertyFluidTank;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandler;
import voltaic.api.gas.PropertyGasTank;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.components.utils.IComponentFluidHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class TileAdvancedThermoelectricManipulator
extends GenericTileThermoelectricManipulator
implements IMultiblockGasTransformer {
    public boolean hasBeenDestroyed = false;

    public TileAdvancedThermoelectricManipulator(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_ADVANCED_THERMOELECTRIC_MANIPULATOR.get(), worldPos, blockState);
    }

    @Override
    public void tickClient(ComponentTickable tickable) {
        ElectrodynamicsBlockStates.ManipulatorHeatingStatus status = (ElectrodynamicsBlockStates.ManipulatorHeatingStatus)((Object)this.m_58900_().m_61143_(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS));
        if (status == ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.5) {
            double xShift;
            Direction direction = this.getFacing();
            double axisShift = Voltaic.RANDOM.nextDouble(0.25) + 0.1;
            double otherShift = Voltaic.RANDOM.nextDouble(0.63) + 0.1;
            double yShift = Voltaic.RANDOM.nextDouble();
            double d = direction.m_122434_() == Direction.Axis.X ? (double)direction.m_122429_() * (direction.m_122429_() < 0 ? -1.0 + otherShift : otherShift) : (xShift = direction.m_122431_() < 0 ? 1.0 - axisShift : axisShift);
            double zShift = direction.m_122434_() == Direction.Axis.Z ? (double)direction.m_122431_() * (direction.m_122431_() < 0 ? -1.0 + otherShift : otherShift) : (direction.m_122429_() < 0 ? axisShift : 1.0 - axisShift);
            SimpleParticleType particle = status == ElectrodynamicsBlockStates.ManipulatorHeatingStatus.HEAT ? ParticleTypes.f_123762_ : ParticleTypes.f_175821_;
            this.f_58857_.m_7106_((ParticleOptions)particle, (double)this.f_58858_.m_123341_() + xShift, (double)this.f_58858_.m_123342_() + yShift, (double)this.f_58858_.m_123343_() + zShift, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public ComponentContainerProvider getContainerProvider() {
        return new ComponentContainerProvider("advancedthermoelectricmanipulator", (GenericTile)this).createMenu((id, inv) -> new ContainerThermoelectricManipulator((int)id, (Inventory)inv, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
    }

    @Override
    public double getUsagePerTick() {
        return ElectroConstants.ADVANCED_THERMOELECTRIC_MANIPULATOR_USAGE_PER_TICK;
    }

    @Override
    public int getConversionRate() {
        return ElectroConstants.ADVANCED_THERMOELECTRIC_MANIPULATOR_CONVERSION_RATE;
    }

    @Override
    public void updateAddonTanks(int count, boolean isLeft) {
        ComponentGasHandlerMulti handler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        if (isLeft) {
            multi.getInputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * count);
            handler.getInputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * count);
        } else {
            multi.getOutputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * count);
            handler.getOutputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * count);
        }
    }

    @Override
    public boolean hasBeenDestroyed() {
        return this.hasBeenDestroyed;
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        Direction facing = this.getFacing();
        BlockEntity left = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.EAST)));
        BlockEntity right = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.WEST)));
        if (left != null && right != null && left instanceof TileGasTransformerSideBlock) {
            TileGasTransformerSideBlock leftTile = (TileGasTransformerSideBlock)left;
            if (right instanceof TileGasTransformerSideBlock) {
                TileGasTransformerSideBlock rightTile = (TileGasTransformerSideBlock)right;
                leftTile.setOwnerPos(this.m_58899_());
                leftTile.setIsLeft();
                leftTile.m_6596_();
                rightTile.setOwnerPos(this.m_58899_());
                rightTile.m_6596_();
            }
        }
    }

    public void onBlockDestroyed() {
        if (this.f_58857_.f_46443_ || this.hasBeenDestroyed) {
            return;
        }
        this.hasBeenDestroyed = true;
        Direction facing = this.getFacing();
        this.m_58904_().m_46961_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.WEST)), false);
        this.m_58904_().m_46961_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.EAST)), false);
    }

    @Override
    public void outputToPipe(ComponentProcessor processor, ComponentGasHandlerMulti gasHandler, Direction facing) {
        IFluidHandler handler;
        GasStack taken;
        int amtAccepted;
        IGasHandler handler2;
        Direction direction = BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)BlockEntityUtils.MachineDirection.LEFT.mappedDir);
        BlockPos face = this.m_58899_().m_5484_(direction, 2);
        BlockEntity faceTile = this.m_58904_().m_7702_(face);
        if (faceTile != null && (handler2 = (IGasHandler)faceTile.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, direction.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_GAS)) != CapabilityUtils.EMPTY_GAS) {
            PropertyGasTank gasTank = gasHandler.getOutputTanks()[0];
            for (int i = 0; i < handler2.getTanks(); ++i) {
                GasStack tankGas = gasTank.getGas();
                amtAccepted = handler2.fill(tankGas, GasAction.EXECUTE);
                taken = new GasStack(tankGas.getGas(), amtAccepted, tankGas.getTemperature(), tankGas.getPressure());
                gasTank.drain(taken, GasAction.EXECUTE);
            }
        }
        ComponentFluidHandlerMulti fluidHandler = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        face = this.m_58899_().m_121945_(direction).m_121945_(Direction.DOWN);
        faceTile = this.m_58904_().m_7702_(face);
        if (faceTile != null && (handler = (IFluidHandler)faceTile.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).orElse((Object)CapabilityUtils.EMPTY_FLUID)) != CapabilityUtils.EMPTY_FLUID) {
            PropertyFluidTank fluidTank = fluidHandler.getOutputTanks()[0];
            FluidStack tankFluid = fluidTank.getFluid();
            amtAccepted = handler.fill(tankFluid, IFluidHandler.FluidAction.EXECUTE);
            taken = new FluidStack(tankFluid.getFluid(), amtAccepted);
            fluidTank.drain((FluidStack)taken, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void updateLit(boolean isHeating, Direction facing) {
        if (BlockEntityUtils.isLit((GenericTile)this) ^ isHeating) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)isHeating);
            BlockEntity left = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.EAST)));
            BlockEntity right = this.m_58904_().m_7702_(this.m_58899_().m_121945_(BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)Direction.WEST)));
            if (left != null && left instanceof TileGasTransformerSideBlock) {
                TileGasTransformerSideBlock leftTile = (TileGasTransformerSideBlock)left;
                if (right != null && right instanceof TileGasTransformerSideBlock) {
                    TileGasTransformerSideBlock rightTile = (TileGasTransformerSideBlock)right;
                    BlockEntityUtils.updateLit((GenericTile)leftTile, (Boolean)isHeating);
                    BlockEntityUtils.updateLit((GenericTile)rightTile, (Boolean)isHeating);
                }
            }
        }
    }

    @Override
    public IComponentFluidHandler getFluidHandler() {
        return new ComponentFluidHandlerMulti.ComponentFluidHandlerMultiBiDirec((GenericTile)this).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setInputTanks(1, TileAdvancedThermoelectricManipulator.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY})).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setOutputTanks(1, TileAdvancedThermoelectricManipulator.arr((int[])new int[]{ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY}));
    }

    @Override
    public int getHeatTransfer() {
        return ElectroConstants.ADVANCED_THERMOELECTRIC_MANIPULATOR_HEAT_TRANSFER;
    }
}

