/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer.thermoelectricmanipulator;

import electrodynamics.common.block.states.ElectrodynamicsBlockStates;
import electrodynamics.common.inventory.container.tile.ContainerThermoelectricManipulator;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.gas.gastransformer.IAddonTankManager;
import electrodynamics.common.tile.pipelines.gas.gastransformer.TileGasTransformerAddonTank;
import electrodynamics.common.tile.pipelines.gas.gastransformer.thermoelectricmanipulator.GenericTileThermoelectricManipulator;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.components.utils.IComponentFluidHandler;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileBasicThermoelectricManipulator
extends GenericTileThermoelectricManipulator
implements IAddonTankManager {
    public TileBasicThermoelectricManipulator(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_THERMOELECTRIC_MANIPULATOR.get(), worldPos, blockState);
    }

    @Override
    public void outputToPipe(ComponentProcessor processor, ComponentGasHandlerMulti multi, Direction facing) {
        processor.outputToFluidPipe();
        processor.outputToGasPipe();
    }

    @Override
    public void updateLit(boolean isHeating, Direction facing) {
        if (BlockEntityUtils.isLit((GenericTile)this) ^ isHeating) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)isHeating);
        }
    }

    @Override
    public IComponentFluidHandler getFluidHandler() {
        return new ComponentFluidHandlerMulti((GenericTile)this).setInputTanks(1, new int[]{ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY}).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).setOutputTanks(1, new int[]{ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.FRONT});
    }

    @Override
    public int getHeatTransfer() {
        return ElectroConstants.THERMOELECTRIC_MANIPULATOR_HEAT_TRANSFER;
    }

    @Override
    public ComponentContainerProvider getContainerProvider() {
        return new ComponentContainerProvider("thermoelectricmanipulator", (GenericTile)this).createMenu((id, inv) -> new ContainerThermoelectricManipulator((int)id, (Inventory)inv, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
    }

    @Override
    public double getUsagePerTick() {
        return ElectroConstants.THERMOELECTRIC_MANIPULATOR_USAGE_PER_TICK;
    }

    @Override
    public int getConversionRate() {
        return ElectroConstants.THERMOELECTRIC_MANIPULATOR_CONVERSION_RATE;
    }

    @Override
    public void tickClient(ComponentTickable tickable) {
        ElectrodynamicsBlockStates.ManipulatorHeatingStatus status = (ElectrodynamicsBlockStates.ManipulatorHeatingStatus)((Object)this.m_58900_().m_61143_(ElectrodynamicsBlockStates.MANIPULATOR_HEATING_STATUS));
        if (status == ElectrodynamicsBlockStates.ManipulatorHeatingStatus.OFF) {
            return;
        }
        if (this.f_58857_.f_46441_.m_188500_() < 0.5) {
            // empty if block
        }
    }

    @Override
    public void updateTankCount() {
        BlockEntity aboveTile;
        BlockPos abovePos = this.m_58899_().m_7494_();
        BlockState aboveState = this.m_58904_().m_8055_(abovePos);
        int tankCount = 0;
        for (int i = 0; i < ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_LIMIT && aboveState.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK.get()) && (aboveTile = this.m_58904_().m_7702_(abovePos)) != null && aboveTile instanceof TileGasTransformerAddonTank; ++i) {
            TileGasTransformerAddonTank tank = (TileGasTransformerAddonTank)aboveTile;
            abovePos = abovePos.m_7494_();
            aboveState = this.m_58904_().m_8055_(abovePos);
            tank.setOwnerPos(this.m_58899_());
            ++tankCount;
        }
        ComponentGasHandlerMulti handler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        ComponentFluidHandlerMulti multi = (ComponentFluidHandlerMulti)this.getComponent(IComponentType.FluidHandler);
        multi.getInputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * tankCount);
        handler.getInputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * tankCount);
        multi.getOutputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * tankCount);
        handler.getOutputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * tankCount);
    }
}

