/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.tank;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerGasTankGeneric;
import electrodynamics.registers.ElectrodynamicsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.GasTank;
import voltaic.common.network.utils.GasUtilities;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentGasHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericGasTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class GenericTileGasTank
extends GenericGasTile {
    public static final double INSULATION_EFFECTIVENESS = 1.05;
    public static final double HEAT_LOSS = 0.0025;
    public final SingleProperty<Double> insulationBonus = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "insulationbonus", (Object)1.0));

    public GenericTileGasTank(BlockEntityType<?> type, BlockPos pos, BlockState state, SubtypeMachine machine, int capacity, int maxPressure, int maxTemperature) {
        super(type, pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentGasHandlerSimple((GenericTile)this, "", capacity, maxTemperature, maxPressure).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).setOnGasCondensed(this.getCondensedHandler()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(6).gasInputs(1).gasOutputs(1)).valid(GenericTileGasTank.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(machine.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerGasTankGeneric((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tick) {
        BlockEntity temperatureDecrease2;
        ComponentGasHandlerSimple handler = (ComponentGasHandlerSimple)this.getComponent(IComponentType.GasHandler);
        GasUtilities.drainItem((GenericTile)this, (GasTank[])handler.asArray());
        GasUtilities.fillItem((GenericTile)this, (GasTank[])handler.asArray());
        GasUtilities.outputToPipe((GenericTile)this, (GasTank[])handler.asArray(), (Direction[])handler.outputDirections);
        GasStack gasIn = handler.getGas();
        if (!gasIn.isEmpty() && gasIn.getTemperature() != 293) {
            int deltaT = (int)Math.signum(293 - gasIn.getTemperature());
            int temperatureDecrease2 = (int)(Math.max(1.0, 0.0025 / Math.max(1.0, (Double)this.insulationBonus.getValue())) * (double)deltaT);
            handler.heat(0, temperatureDecrease2, GasAction.EXECUTE);
        }
        if ((temperatureDecrease2 = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) instanceof GenericTileGasTank) {
            GenericTileGasTank tankBelow = (GenericTileGasTank)temperatureDecrease2;
            ComponentGasHandlerSimple belowHandler = (ComponentGasHandlerSimple)tankBelow.getComponent(IComponentType.GasHandler);
            handler.drain(belowHandler.fill(handler.getGas(), GasAction.EXECUTE), GasAction.EXECUTE);
        }
    }

    public int getComparatorSignal() {
        ComponentGasHandlerSimple handler = (ComponentGasHandlerSimple)this.getComponent(IComponentType.GasHandler);
        return (int)((double)(handler.getGasAmount() / Math.max(1, handler.getCapacity())) * 15.0);
    }

    public void onInventoryChange(ComponentInventory inv, int slot) {
        super.onInventoryChange(inv, slot);
        if (slot > 5) {
            return;
        }
        double insulationBonus = 1.0;
        for (ItemStack item : inv.getInputContents()) {
            if (item.m_41720_() != ElectrodynamicsItems.ITEM_FIBERGLASSSHEET.get()) continue;
            insulationBonus *= 1.05;
        }
        this.insulationBonus.setValue((Object)insulationBonus);
    }
}

