/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen;

import electrodynamics.common.block.subtype.SubtypeWire;
import electrodynamics.datagen.client.ElectrodynamicsBlockModelsProvider;
import electrodynamics.datagen.client.ElectrodynamicsBlockStateProvider;
import electrodynamics.datagen.client.ElectrodynamicsItemModelsProvider;
import electrodynamics.datagen.client.ElectrodynamicsLangKeyProvider;
import electrodynamics.datagen.client.ElectrodynamicsSoundProvider;
import electrodynamics.datagen.server.CoalGeneratorFuelSourceProvider;
import electrodynamics.datagen.server.CombustionChamberFuelSourceProvider;
import electrodynamics.datagen.server.ElectrodynamicsAdvancementProvider;
import electrodynamics.datagen.server.ElectrodynamicsLootTablesProvider;
import electrodynamics.datagen.server.ThermoelectricGenHeatSourceProvider;
import electrodynamics.datagen.server.radiation.ElectrodynamicsRadiationShieldingProvider;
import electrodynamics.datagen.server.radiation.ElectrodynamicsRadioactiveBlocksProvider;
import electrodynamics.datagen.server.radiation.ElectrodynamicsRadioactiveItemsProvider;
import electrodynamics.datagen.server.recipe.ElectrodynamicsRecipeProvider;
import electrodynamics.datagen.server.tags.ElectrodynamicsTagsProvider;
import electrodynamics.registers.ElectrodynamicsDamageTypes;
import electrodynamics.registers.ElectrodynamicsFeatures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import voltaic.api.network.cable.type.IWire;
import voltaic.datagen.utils.client.BaseLangKeyProvider;

@Mod.EventBusSubscriber(modid="electrodynamics", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    public static final HashMap<IWire.IWireClass, HashSet<SubtypeWire>> WIRES = new HashMap();

    @Nullable
    public static SubtypeWire getWire(IWire.IWireMaterial conductor, SubtypeWire.InsulationMaterial insulation, SubtypeWire.WireClass wireClass, SubtypeWire.WireColor color) {
        for (SubtypeWire wire : WIRES.getOrDefault((Object)wireClass, new HashSet())) {
            if (wire.getWireMaterial() != conductor || wire.getInsulation() != insulation || wire.getWireClass() != wireClass || wire.getWireColor() != color) continue;
            return wire;
        }
        return null;
    }

    public static SubtypeWire[] getWires(IWire.IWireMaterial[] conductors, SubtypeWire.InsulationMaterial insulation, SubtypeWire.WireClass wireClass, SubtypeWire.WireColor ... colors) {
        ArrayList<SubtypeWire> list = new ArrayList<SubtypeWire>();
        for (IWire.IWireMaterial conductor : conductors) {
            for (SubtypeWire.WireColor color : colors) {
                SubtypeWire wire = DataGenerators.getWire(conductor, insulation, wireClass, color);
                if (wire == null) continue;
                list.add(wire);
            }
        }
        return list.toArray(new SubtypeWire[0]);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper helper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            generator.addProvider(true, (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ElectrodynamicsLootTablesProvider::new, LootContextParamSets.f_81421_))));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsRecipeProvider(output));
            generator.addProvider(true, (DataProvider)new CombustionChamberFuelSourceProvider(output));
            generator.addProvider(true, (DataProvider)new CoalGeneratorFuelSourceProvider(output));
            generator.addProvider(true, (DataProvider)new ThermoelectricGenHeatSourceProvider(output));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsRadioactiveBlocksProvider(output));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsRadioactiveItemsProvider(output));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsRadiationShieldingProvider(output));
            generator.addProvider(true, (DataProvider)new ForgeAdvancementProvider(output, event.getLookupProvider(), helper, List.of(new ElectrodynamicsAdvancementProvider())));
            DatapackBuiltinEntriesProvider datapacks = new DatapackBuiltinEntriesProvider(output, lookupProvider, new RegistrySetBuilder().m_254916_(Registries.f_268580_, ElectrodynamicsDamageTypes::registerTypes).m_254916_(Registries.f_256911_, context -> ElectrodynamicsFeatures.registerConfigured(context)).m_254916_(Registries.f_256988_, ElectrodynamicsFeatures::registerPlaced).m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, ElectrodynamicsFeatures::registerModifiers), Set.of("electrodynamics"));
            generator.addProvider(true, (DataProvider)datapacks);
            ElectrodynamicsTagsProvider.addTagProviders(generator, output, datapacks.getRegistryProvider(), helper);
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new ElectrodynamicsBlockStateProvider(output, helper));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsBlockModelsProvider(output, helper));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsItemModelsProvider(output, helper));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsLangKeyProvider(output, BaseLangKeyProvider.Locale.EN_US));
            generator.addProvider(true, (DataProvider)new ElectrodynamicsSoundProvider(output, helper));
        }
    }

    static {
        for (SubtypeWire wire : SubtypeWire.values()) {
            HashSet<SubtypeWire> wireSet = WIRES.getOrDefault(wire.getWireClass(), new HashSet());
            wireSet.add(wire);
            WIRES.put(wire.getWireClass(), wireSet);
        }
    }
}

