/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen.server.recipe.types.custom.fluid2item;

import electrodynamics.common.fluid.subtype.SubtypeSulfateFluid;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsRecipies;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import voltaic.common.tags.VoltaicTags;
import voltaic.datagen.utils.server.recipe.AbstractRecipeGenerator;
import voltaic.datagen.utils.server.recipe.FinishedRecipeBase;
import voltaic.datagen.utils.server.recipe.FinishedRecipeItemOutput;

public class ElectrodynamicsChemicalCrystallizerRecipes
extends AbstractRecipeGenerator {
    public static double CHEMICALCRYSTALLIZER_USAGE_PER_TICK = 800.0;
    public static int CHEMICALCRYSTALLIZER_REQUIRED_TICKS = 200;
    private final String modID;

    public ElectrodynamicsChemicalCrystallizerRecipes(String modID) {
        this.modID = modID;
    }

    public ElectrodynamicsChemicalCrystallizerRecipes() {
        this("electrodynamics");
    }

    public void addRecipes(Consumer<FinishedRecipe> consumer) {
        this.newRecipe(new ItemStack((ItemLike)Items.f_42461_), 0.0f, 200, 800.0, "clay_ball").addFluidTagInput(VoltaicTags.Fluids.CLAY, 200).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_41999_), 0.0f, 200, 800.0, "obsidian_from_lava").addFluidTagInput(FluidTags.f_13132_, 1000).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_PLASTIC_FIBERS.get()), 0.0f, 200, 800.0, "plastic_fibers").addFluidTagInput(VoltaicTags.Fluids.POLYETHLYENE, 1000).complete(consumer);
        for (SubtypeSulfateFluid fluid : SubtypeSulfateFluid.values()) {
            if (fluid.crystal == null) continue;
            this.newRecipe(new ItemStack((ItemLike)fluid.crystal.get()), 0.0f, 200, 800.0, "crystal_" + fluid.name() + "_from_sulfate").addFluidTagInput(fluid.tag, 200).complete(consumer);
        }
    }

    public FinishedRecipeItemOutput newRecipe(ItemStack stack, float xp, int ticks, double usagePerTick, String name) {
        return FinishedRecipeItemOutput.of((RecipeSerializer)((RecipeSerializer)ElectrodynamicsRecipies.CHEMICAL_CRYSTALIZER_SERIALIZER.get()), (ItemStack)stack, (double)xp, (int)ticks, (double)usagePerTick).name(FinishedRecipeBase.RecipeCategory.FLUID_2_ITEM, this.modID, "chemical_crystallizer/" + name);
    }
}

