/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.prefab.screen.component;

import electrodynamics.common.tile.pipelines.gas.TileGasPipeFilter;
import electrodynamics.registers.ElectrodynamicsSounds;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.api.screen.ITexture;
import voltaic.prefab.inventory.container.GenericContainer;
import voltaic.prefab.inventory.container.types.GenericContainerBlockEntity;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.screen.GenericScreen;
import voltaic.prefab.screen.component.ScreenComponentGeneric;
import voltaic.prefab.screen.component.types.gauges.ScreenComponentGasGauge;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class ScreenComponentGasFilter
extends ScreenComponentGeneric {
    private final int index;

    public ScreenComponentGasFilter(int x, int y, int index) {
        super((ITexture)ScreenComponentGasGauge.GasGaugeTextures.BACKGROUND_DEFAULT, x, y);
        this.index = index;
    }

    public void renderBackground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(graphics, xAxis, yAxis, guiWidth, guiHeight);
        TileGasPipeFilter filter = (TileGasPipeFilter)((GenericContainerBlockEntity)((GenericScreen)this.gui).m_6262_()).getSafeHost();
        if (filter == null) {
            return;
        }
        SingleProperty property = filter.filteredGases[this.index];
        if (!((GasStack)property.getValue()).isEmpty()) {
            ScreenComponentGasGauge.renderMercuryTexture((GuiGraphics)graphics, (int)(guiWidth + this.xLocation + 1), (int)(guiHeight + this.yLocation + 1), (float)1.0f);
        }
        ScreenComponentGasGauge.GasGaugeTextures texture = ScreenComponentGasGauge.GasGaugeTextures.LEVEL_DEFAULT;
        graphics.m_280163_(texture.getLocation(), guiWidth + this.xLocation, guiHeight + this.yLocation, (float)texture.textureU(), (float)texture.textureV(), texture.textureWidth(), texture.textureHeight(), texture.imageWidth(), texture.imageHeight());
    }

    public void renderForeground(GuiGraphics graphics, int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (!this.isPointInRegion(this.xLocation, this.yLocation, xAxis, yAxis, this.texture.textureWidth(), this.texture.textureHeight())) {
            return;
        }
        TileGasPipeFilter filter = (TileGasPipeFilter)((GenericContainerBlockEntity)((GenericScreen)this.gui).m_6262_()).getSafeHost();
        if (filter == null) {
            return;
        }
        ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
        SingleProperty property = filter.filteredGases[this.index];
        tooltips.add(((GasStack)property.getValue()).getGas().getDescription().m_7532_());
        graphics.m_280245_(this.gui.getFontRenderer(), tooltips, xAxis, yAxis);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isActiveAndVisible() && this.isValidClick(button) && this.isInClickRegion(mouseX, mouseY)) {
            this.onMouseClick(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.isValidClick(button)) {
            this.onMouseRelease(mouseX, mouseY);
            return true;
        }
        return false;
    }

    public void onMouseClick(double mouseX, double mouseY) {
        GenericScreen screen = (GenericScreen)this.gui;
        TileGasPipeFilter filter = (TileGasPipeFilter)((GenericContainerBlockEntity)screen.m_6262_()).getSafeHost();
        if (filter == null) {
            return;
        }
        SingleProperty property = filter.filteredGases[this.index];
        ItemStack holding = ((GenericContainer)screen.m_6262_()).m_142621_();
        if (holding.m_41619_()) {
            if (!Screen.m_96638_()) {
                return;
            }
            property.setValue((Object)GasStack.EMPTY);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_PRESSURERELEASE.get()), (float)1.0f));
            return;
        }
        IGasHandlerItem handler = (IGasHandlerItem)holding.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM);
        if (handler == CapabilityUtils.EMPTY_GAS_ITEM) {
            return;
        }
        GasStack taken = handler.drain(Integer.MAX_VALUE, GasAction.SIMULATE);
        if (taken.isEmpty()) {
            return;
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_PRESSURERELEASE.get()), (float)1.0f));
        property.setValue((Object)taken);
    }
}

