/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.base.common.recipe;

import com.enderio.api.capability.IEntityStorage;
import com.enderio.base.common.init.EIOCapabilities;
import com.enderio.base.common.init.EIORecipes;
import com.google.gson.JsonObject;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ShapedEntityStorageRecipe
extends ShapedRecipe {
    public static final Set<ResourceLocation> REGISTERED_RECIPES = new LinkedHashSet<ResourceLocation>();

    public ShapedEntityStorageRecipe(ShapedRecipe recipe) {
        super(recipe.m_6423_(), recipe.m_6076_(), recipe.m_245232_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), recipe.m_7527_(), recipe.f_44149_);
        REGISTERED_RECIPES.add(recipe.m_6423_());
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = super.m_5874_(container, registryAccess);
        this.getInputEntityStorage(container).ifPresent(inputStorage -> result.getCapability(EIOCapabilities.ENTITY_STORAGE).ifPresent(resultStorage -> resultStorage.setStoredEntityData(inputStorage.getStoredEntityData())));
        return result;
    }

    public boolean m_5818_(CraftingContainer pInv, Level pLevel) {
        return this.getInputEntityStorage(pInv).isPresent() && super.m_5818_(pInv, pLevel);
    }

    private LazyOptional<IEntityStorage> getInputEntityStorage(CraftingContainer container) {
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stack = container.m_8020_(slot);
            LazyOptional storage = stack.getCapability(EIOCapabilities.ENTITY_STORAGE);
            if (!storage.isPresent()) continue;
            return storage;
        }
        return LazyOptional.empty();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EIORecipes.SHAPED_ENTITY_STORAGE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedEntityStorageRecipe> {
        public ShapedEntityStorageRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            return new ShapedEntityStorageRecipe((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(pRecipeId, pSerializedRecipe));
        }

        @Nullable
        public ShapedEntityStorageRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            ShapedRecipe shaped = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(pRecipeId, pBuffer);
            if (shaped == null) {
                return null;
            }
            return new ShapedEntityStorageRecipe(shaped);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ShapedEntityStorageRecipe pRecipe) {
            RecipeSerializer.f_44076_.m_6178_(pBuffer, (Recipe)pRecipe);
        }
    }
}

