/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.network;

import com.enderio.core.common.network.Packet;
import com.enderio.machines.common.blockentity.task.SpawnerMachineTask;
import com.enderio.machines.common.souldata.SpawnerSoul;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PoweredSpawnerSoulPacket
implements Packet {
    private final Map<ResourceLocation, SpawnerSoul.SoulData> map;

    public PoweredSpawnerSoulPacket(Map<ResourceLocation, SpawnerSoul.SoulData> map) {
        this.map = map;
    }

    public PoweredSpawnerSoulPacket(FriendlyByteBuf buf) {
        this.map = buf.m_236847_(FriendlyByteBuf::m_130281_, buff -> new SpawnerSoul.SoulData(buff.m_130281_(), buff.readInt(), (SpawnerMachineTask.SpawnType)buff.m_130066_(SpawnerMachineTask.SpawnType.class)));
    }

    protected void write(FriendlyByteBuf writeInto) {
        writeInto.m_236831_(this.map, FriendlyByteBuf::m_130085_, (buf, soulData) -> {
            buf.m_130085_(soulData.entitytype());
            buf.writeInt(soulData.power());
            buf.m_130068_((Enum)soulData.spawnType());
        });
    }

    @Override
    public boolean isValid(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            SpawnerSoul.SPAWNER.map = this.map;
        });
        context.setPacketHandled(true);
    }

    public static class Handler
    extends Packet.PacketHandler<PoweredSpawnerSoulPacket> {
        @Override
        public PoweredSpawnerSoulPacket fromNetwork(FriendlyByteBuf buf) {
            return new PoweredSpawnerSoulPacket(buf);
        }

        @Override
        public void toNetwork(PoweredSpawnerSoulPacket packet, FriendlyByteBuf buf) {
            packet.write(buf);
        }

        @Override
        public Optional<NetworkDirection> getDirection() {
            return Optional.of(NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

